package jp.ecuacion.splib.web.tool.form.record;

import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.splib.web.tool.bean.HtmlItem;

public interface EditRecordInterface extends RecordInterface {
  
  default List<String> getNotEmptyFields() {
    List<String> list = new ArrayList<>();
    
    HtmlItem[] htmlItems = getHtmlItems();
    for (HtmlItem item : htmlItems) {
      if (item.getIsNotEmpty()) {
        list.add(item.getItemName());
      }
    }
    
    return list;
  }
  
  default boolean isNotEmpty(String fieldName) {
    return getNotEmptyFields().contains(fieldName);
  }
}
