package jp.ecuacion.splib.web.tool.form;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.tool.advice.SplibExceptionHandlerNoJpa;
import jp.ecuacion.splib.web.tool.form.record.EditRecordInterface;

public abstract class SplibEditForm extends SplibForm {

  /** insertかupdateかを保持。 */
  protected boolean isInsert;

  public boolean isInsert() {
    return isInsert;
  }

  public void setIsInsert(boolean isInsert) {
    this.isInsert = isInsert;
  }

  // /** form内に指定されているrecordを全てlistで返す */
  // protected abstract Map<String, SplibJpaRecord> getAllRecordMap();

  /** EditFormのメソッドを呼び出すことで、その中の全てのNotEmpty Checkを実施。 */
  public boolean hasNotEmptyError() {
    return validateNotEmpty().size() > 0;
  }

  /** NotEmptyエラーの有無・件数だけを知りたい場合で、localeを取得するのが面倒な際はこちらを使用。 */
  public Set<SplibExceptionHandlerNoJpa.ValidationErrorInfoBean> validateNotEmpty() {
    return validateNotEmpty(Locale.getDefault());
  }

  /** NotEmptyエラーのメッセージを取得したい場合はこちらを使用。 */
  public Set<SplibExceptionHandlerNoJpa.ValidationErrorInfoBean> validateNotEmpty(Locale locale) {

    final String validationClass = "jakarta.validation.constraints.NotEmpty";
    Set<SplibExceptionHandlerNoJpa.ValidationErrorInfoBean> rtnSet = new HashSet<>();

    Field rootRecordField = getRootRecordField();
    String rootRecordFieldName = rootRecordField.getName();
    EditRecordInterface rootRecord = (EditRecordInterface) getRootRecord(rootRecordField);

    for (String notEmptyField : ((EditRecordInterface) rootRecord).getNotEmptyFields()) {
      Object value = ((SplibRecord) rootRecord).getValue(notEmptyField);

      if (value == null || (value instanceof String && ((String) value).equals(""))) {
        rtnSet.add(new SplibExceptionHandlerNoJpa.ValidationErrorInfoBean(
            ResourceBundle.getBundle("ValidationMessages", locale)
                .getString(validationClass + ".message"),
            rootRecordFieldName + "." + notEmptyField, validationClass));
      }
    }

    return rtnSet;
  }
}
