/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.tool.service;

import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.Set;
import jp.ecuacion.lib.core.entity.AbstractEntity;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.AppWarningException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapper;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import jp.ecuacion.splib.web.tool.form.SplibEditForm;
import jp.ecuacion.splib.web.tool.form.SplibListForm;
import jp.ecuacion.splib.web.tool.form.SplibSearchConditionForm;
import jp.ecuacion.splib.web.tool.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class SplibService<E extends AbstractEntity> {
    @Autowired
    private HttpServletRequest request;
    protected EntityManagerWrapper em;

    public DatetimeFormatParameters getParams() {
        return new SplibUtil().getParams(this.request);
    }

    protected boolean isInsert(String id) {
        return id == null || id.equals("");
    }

    protected LocalDate localDate(String date) {
        return date == null || date.equals("") ? null : LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public void setEntityManager(EntityManagerWrapper em) {
        this.em = em;
    }

    protected abstract SplibRepository<E, Long> getRepositoryForOptimisticLocking();

    protected abstract void putNullToAuditingFields(E var1);

    protected abstract Object getVersion(E var1);

    protected AbstractEntity findAndOptimisticLockingCheck(String id, String versionInScreen, ActionPattern pattern) throws AppException {
        Optional optional = this.getRepositoryForOptimisticLocking().findById((Object)Long.valueOf(id));
        if (pattern == ActionPattern.DELETE && optional.isEmpty()) {
            String msg = "jp.ecuacion.splib.web.tool.common.message.sameRecordAlreadyDeleted";
            throw new CustomizedValidationAppException(msg);
        }
        AbstractEntity e = (AbstractEntity)optional.get();
        if (pattern == ActionPattern.EDIT || pattern == ActionPattern.DELETE) {
            this.putNullToAuditingFields(e);
        }
        if (!versionInScreen.equals(this.getVersion(e).toString())) {
            throw new ObjectOptimisticLockingFailureException("some class", (Object)id);
        }
        return e;
    }

    public abstract SplibListForm<? extends SplibRecord> getListForm(SplibSearchConditionForm var1) throws MultipleAppException;

    protected abstract Specification<E> getSpecs(SplibSearchConditionForm var1);

    protected Page<E> getListFormCommon(SplibSearchConditionForm searchConditionForm, JpaSpecificationExecutor<E> repository) {
        Specification<E> specs = this.getSpecs(searchConditionForm);
        searchConditionForm.setNumberOfRecordsAndAdjustCurrentPageNumger(repository.count(specs));
        return repository.findAll(specs, (Pageable)searchConditionForm.getPageRequest());
    }

    protected void throwWarning(Set<String> confirmedWarningMessageSet, String msgId) throws AppWarningException {
        if (!confirmedWarningMessageSet.contains(msgId)) {
            throw new AppWarningException(msgId);
        }
    }

    public abstract SplibEditForm getInsertForm(SplibEditForm var1) throws AppException;

    public abstract SplibEditForm getUpdateForm(SplibEditForm var1) throws Exception;

    public abstract void edit(SplibEditForm var1, UserDetails var2) throws Exception;

    public abstract void delete(SplibEditForm var1, UserDetails var2) throws Exception;

    public abstract void prepareEditForm(SplibEditForm var1);

    public static enum ActionPattern {
        GET_UPDATE_FORM,
        EDIT,
        DELETE;

    }
}

