package jp.ecuacion.splib.web.tool.util;

import java.util.Arrays;
import java.util.List;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.MailUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class SplibMailUtil {
  
  public void sendMailOnSystemErrorFromSettingsInApplicationProperties(Throwable th) {
    List<String> errorMailAddressList =
        Arrays.asList(PropertyFileUtil.getApp("MAIL_SYSTEM_ERROR_CSV_LIST").split(","));
    
    // エラー内容をメールで送信
    try {
      if (errorMailAddressList == null || errorMailAddressList.size() == 0) {
        return;
      }

      // メールする。メールができない状況にあった場合はどうしようもないので握りつぶす
      try {
        new MailUtil().sendErrorMail(th, errorMailAddressList);
      } catch (Exception ex) {
        ex.printStackTrace();
      }
      
    } catch (Throwable th1) {
      // ログに出力
      try {
        new LogUtil().logErr(th1);
        
      } catch (Throwable th2) {
        // ここまでくるとどうにもならないので標準出力に出力。それもダメなら何もしない
        try {
          th1.printStackTrace();
        } catch (Throwable th3) {
          // 何もしない
        }
      }
    }
  }

}
