package jp.ecuacion.splib.web.tool.form.enums;

public enum BooleanOnSearchEnum {
  
  ALL("0"), TRUE("1"), FALSE("2");

  private String code;

  private BooleanOnSearchEnum(String code) {
    this.code = code;
  }
  
  public String getCode() {
    return code;
  }
  
  public static BooleanOnSearchEnum getEnumFromCode(String code) {
    // 画面から受け取る値がnullや""の場合はALLとして扱う
    code = code == null || code.equals("") ? "0" : code;
    
    for (BooleanOnSearchEnum anEnum : BooleanOnSearchEnum.values()) {
      if (anEnum.getCode().equals(code)) {
        return anEnum;
      }
    }
    
    // ここまでくるのは不正の値を引数に指定した場合のみ。
    throw new RuntimeException("[account-book-admin] Program Incorrect.");
  }
  
  public Boolean getSearchValue() {
    
    if (this == ALL) {
      return null;
      
    } else if (this == TRUE) {
      return true;
      
    } else {
      return false;
    }
  }
}
