package jp.ecuacion.splib.web.tool.bean;

import java.util.HashMap;
import java.util.Map;

/** modelAttribute */
public class SplibModelAttributes extends HashMap<String, Object> {

  private static final long serialVersionUID = 1L;
  
  // optionalだがlibrary側で対応が入っているものはあらかじめ本classないで管理しておく

  private boolean needsBootstrapBgGradient;
  
  /** 
   * 基本はlight(default) / dark の2種類しか設定しないと思われるが、
   * カラーモードを追加することもbootstrapとしては可能なので、内部的にはカラーモード名を持つ形とする。
   * 通常使うものでもないのでdefaultでlightとしておく。
   */
  private String bootstrapDarkMode = "light";

  /** 
   * library側で対応は入っていないがapp共通で登録したいmodelAttributeはここに登録。
   * SystemCommonControllerに@ModelAttributeで登録してもいいのだが、library側で対応している項目はここに定義しているので
   * それ以外も併せて本クラスで一限管理することとする。
   */
  private Map<String, Object> appCommonModelAttributeMap;
  

  public Map<String, Object> getAppCommonModelAttributeMap() {
    return appCommonModelAttributeMap;
  }

  /** 追加は、mapをgetするのではなく、わかりやすくkey, valueを引数に渡す形で登録。 */
  public void addAppCommonModelAttribute(String key, Object value) {
    this.appCommonModelAttributeMap.put(key, value);
  }

  public boolean getIsNeedsBootstrapBgGradient() {
    return needsBootstrapBgGradient;
  }

  public void setNeedsBootstrapBgGradient(boolean needsBootstrapBgGradient) {
    this.needsBootstrapBgGradient = needsBootstrapBgGradient;
  }

  public String getBootstrapDarkMode() {
    return bootstrapDarkMode;
  }
  
  /** dark / lightのいずれかをbooleanで選択。 */
  public void setBootstrapDarkMode(boolean isBootstrapDarkMode) {
    if (isBootstrapDarkMode) {
      bootstrapDarkMode = "dark";

    } else {
      bootstrapDarkMode = "light";
    }
  }

  /** 追加のcolor modeが存在する場合に文字列で指定。bootstrapで追加のcolor modeをしていない場合は不要。 */
  public void setBootstrapDarkMode(String bootstrapDarkMode) {
    this.bootstrapDarkMode = bootstrapDarkMode;
  }
}
