package jp.ecuacion.splib.web.tool.advice;

import jp.ecuacion.splib.web.tool.controller.SplibController;
import jp.ecuacion.splib.web.tool.form.SplibEditForm;
import jp.ecuacion.splib.web.tool.form.SplibForm;
import jp.ecuacion.splib.web.tool.form.SplibSearchConditionForm;

public class SplibExceptionHandlerData {

  private String nextPageOnError;

  private SplibController<? extends SplibSearchConditionForm, ? extends SplibEditForm> controller;

  private SplibForm form;

  /** validationを使用しない画面もあるため、defaultはfalseとしておく */
  private boolean usesSpringMvcValidationError;

  /** 遷移後の画面としてlist()を呼び出す場合に使用 */
  public SplibExceptionHandlerData(
      SplibController<? extends SplibSearchConditionForm, ? extends SplibEditForm> controller,
      SplibForm form) {
    this(controller, form, false);
  }

  /** 遷移後の画面としてlist()を呼び出す場合に使用 */
  public SplibExceptionHandlerData(
      SplibController<? extends SplibSearchConditionForm, ? extends SplibEditForm> controller,
      SplibForm form, boolean usesSpringMvcValidationError) {
    this.controller = controller;
    this.usesSpringMvcValidationError = usesSpringMvcValidationError;
    this.form = form;
  }

  /** 遷移後の画面としてnextPageOnErrorを呼び出す場合に使用 */
  public SplibExceptionHandlerData(
      SplibController<? extends SplibSearchConditionForm, ? extends SplibEditForm> controller,
      SplibForm form, String nextPageOnError) {
    this(controller, form, nextPageOnError, false);
  }

  /** 遷移後の画面としてnextPageOnErrorを呼び出す場合に使用 */
  public SplibExceptionHandlerData(
      SplibController<? extends SplibSearchConditionForm, ? extends SplibEditForm> controller,
      SplibForm form, String nextPageOnError, boolean usesSpringMvcValidationError) {
    this.controller = controller;
    this.nextPageOnError = nextPageOnError;
    this.usesSpringMvcValidationError = usesSpringMvcValidationError;
    this.form = form;
  }

  public String getNextPageOnError() {
    return nextPageOnError;
  }

  public void setNextPageOnError(String nextPageOnError) {
    this.nextPageOnError = nextPageOnError;
  }

  public SplibController<? extends SplibSearchConditionForm, ? extends SplibEditForm> getController() {
    return controller;
  }

  public SplibForm getForm() {
    return form;
  }

  public boolean getUsesSpringMvcValidationError() {
    return usesSpringMvcValidationError;
  }
}
