/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.tool.form.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.ecuacion.splib.web.tool.bean.HtmlItem;
import jp.ecuacion.splib.web.tool.bean.HtmlItemNumber;

public interface RecordInterface {
    public HtmlItem[] getHtmlItems();

    default public HtmlItem getHtmlItem(String itemName) {
        return Arrays.asList(this.getHtmlItems()).stream().collect(Collectors.toMap(e -> e.getItemName(), e -> e)).get(itemName);
    }

    default public boolean needsCommas(String itemName) {
        HtmlItem item = Arrays.asList(this.getHtmlItems()).stream().collect(Collectors.toMap(e -> e.getItemName(), e -> e)).get(itemName);
        if (item == null || !(item instanceof HtmlItemNumber)) {
            return false;
        }
        HtmlItemNumber numItem = (HtmlItemNumber)item;
        return numItem.getNeedsCommas();
    }

    default public String getLabelItemName(String rootRecordname, String itemName) {
        Map<String, String> labelNameMap;
        String labelItemName;
        HtmlItem[] htmlItems = this.getHtmlItems();
        if (itemName.startsWith(rootRecordname + ".")) {
            itemName = itemName.substring((rootRecordname + ".").length());
        }
        labelItemName = (labelItemName = (labelNameMap = Arrays.asList(htmlItems).stream().collect(Collectors.toMap(e -> e.getItemName(), e -> e.getLabelItemName() == null ? e.getItemName() : e.getLabelItemName()))).get(itemName)) == null ? itemName : labelItemName;
        return labelItemName.contains(".") ? labelItemName : rootRecordname + "." + labelItemName;
    }

    default public HtmlItem[] mergeHtmlItems(HtmlItem[] items1, HtmlItem[] items2) {
        ArrayList<HtmlItem> list = new ArrayList<HtmlItem>(Arrays.asList(items1));
        List<String> item1Keys = Arrays.asList(items1).stream().map(e -> e.getItemName()).toList();
        for (String item2Key : Arrays.asList(items2).stream().map(e -> e.getItemName()).toList()) {
            if (!item1Keys.contains(item2Key)) continue;
            throw new RuntimeException("'itemName' of HtmlItem[] duplicated with commonHtmlItems. key: " + item2Key);
        }
        list.addAll(Arrays.asList(items2));
        return list.toArray(new HtmlItem[list.size()]);
    }
}

