/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.tool.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jp.ecuacion.lib.core.entity.AbstractEntity;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.splib.core.form.record.SplibJpaRecord;
import jp.ecuacion.splib.jpa.entrypoint.EntryPointWithSpringJpa;
import jp.ecuacion.splib.web.tool.advice.SplibWebToolExceptionHandlerData;
import jp.ecuacion.splib.web.tool.exception.InputValidationException;
import jp.ecuacion.splib.web.tool.form.SplibWebToolEditForm;
import jp.ecuacion.splib.web.tool.form.SplibWebToolForm;
import jp.ecuacion.splib.web.tool.form.SplibWebToolListForm;
import jp.ecuacion.splib.web.tool.form.SplibWebToolSearchConditionForm;
import jp.ecuacion.splib.web.tool.service.SplibWebToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.lang.Nullable;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibWebToolController<S extends SplibWebToolSearchConditionForm, E extends SplibWebToolEditForm>
extends EntryPointWithSpringJpa {
    @Autowired
    protected HttpServletRequest request;
    private String rootRecordName;
    private String functionName;
    private String editSuccessRedirectPath;

    protected abstract S getNewSearchConditionForm();

    public abstract <T extends AbstractEntity> SplibWebToolService<T> getService();

    public SplibWebToolController(String functionName) {
        this.functionName = functionName;
        this.rootRecordName = functionName;
    }

    public SplibWebToolController(String functionName, String rootRecordName) {
        this.functionName = functionName;
        this.rootRecordName = rootRecordName;
    }

    public String getRootRecordName() {
        return this.rootRecordName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    protected void setEditSuccessRedirectPath(String path) {
        this.editSuccessRedirectPath = path;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
        binder.registerCustomEditor(Boolean.class, (PropertyEditor)((Object)new NullSupportCustomBooleanEditor()));
    }

    @ModelAttribute
    protected void setCommonParamsToModel(Model model) {
        model.addAttribute("functionName", (Object)this.functionName);
        model.addAttribute("rootRecordName", (Object)this.rootRecordName);
    }

    @GetMapping(value={"search"})
    public String search(Model model, S f) throws MultipleAppException {
        S searchForm = this.getProperSearchConditionForm(model, f);
        SplibWebToolService service = this.getService();
        service.setEntityManager(this.getDbAccessManager().getEntityManager());
        SplibWebToolListForm<SplibJpaRecord> listForm = this.getService().getListForm((SplibWebToolSearchConditionForm)searchForm);
        listForm.setMenuName(((SplibWebToolForm)searchForm).getMenuName());
        model.addAttribute(this.functionName + "ListForm", listForm);
        return this.functionName + "List";
    }

    public String search(Model model, String menuName) throws MultipleAppException {
        S form = this.getNewSearchConditionForm();
        ((SplibWebToolForm)form).setMenuName(menuName);
        return this.search(model, form);
    }

    protected S getProperSearchConditionForm(Model model, S f) {
        String formName = this.functionName + "SearchConditionForm";
        String key = this.getSessionKey(formName, f);
        if (f != null) {
            if (((SplibWebToolSearchConditionForm)f).isRequestFromSearchForm()) {
                this.request.getSession().setAttribute(key, f);
            }
            if (this.request.getSession().getAttribute(key) == null) {
                this.request.getSession().setAttribute(key, f);
            }
        } else if (this.request.getSession().getAttribute(formName) == null) {
            throw new RuntimeException("f == null cannot be occurred.");
        }
        SplibWebToolSearchConditionForm formUsedForSearch = (SplibWebToolSearchConditionForm)this.request.getSession().getAttribute(this.getSessionKey(formName, f));
        model.addAttribute(formName, (Object)formUsedForSearch);
        return (S)formUsedForSearch;
    }

    private String getSessionKey(String formName, S f) {
        return formName + (String)(f == null || ((SplibWebToolForm)f).getMenuName() == null || ((SplibWebToolForm)f).getMenuName().equals("") ? "" : "." + ((SplibWebToolForm)f).getMenuName());
    }

    @GetMapping(value={"search"}, params={"conditionClear"})
    public String searchConditionClear(Model model, S f) throws MultipleAppException {
        String formName = this.functionName + "SearchConditionForm";
        String sessionKey = formName + (String)(((SplibWebToolForm)f).getMenuName() == null || ((SplibWebToolForm)f).getMenuName().equals("") ? "" : "." + ((SplibWebToolForm)f).getMenuName());
        this.request.getSession().setAttribute(sessionKey, null);
        return "redirect:/" + this.functionName + "/search?" + this.getUrlParams(((SplibWebToolForm)f).getMenuName(), false);
    }

    @GetMapping(value={"list"}, params={"showInsertForm"})
    public String showInsertForm(Model model, E f) throws AppException {
        this.prepareWithMovingToListOnError((SplibWebToolForm)f, model);
        SplibWebToolEditForm form = this.getService().getInsertForm((SplibWebToolEditForm)f);
        form.setIsInsert(true);
        form.setMenuName(((SplibWebToolForm)f).getMenuName());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    @GetMapping(value={"list"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model, E f) throws Exception {
        this.prepareWithMovingToListOnError((SplibWebToolForm)f, model);
        SplibWebToolEditForm form = this.getService().getUpdateForm((SplibWebToolEditForm)f);
        form.setIsInsert(false);
        form.setMenuName(((SplibWebToolForm)f).getMenuName());
        model.addAttribute(this.functionName + "EditForm", (Object)form);
        return this.functionName + "Edit";
    }

    @GetMapping(value={"list"}, params={"delete"})
    public String delete(Model model, E f, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepareWithMovingToListOnError((SplibWebToolForm)f, model);
        this.getService().delete((SplibWebToolEditForm)f, loginUser);
        return "redirect:/" + this.functionName + "/search?success" + this.getUrlParams(((SplibWebToolForm)f).getMenuName(), true);
    }

    protected String getUrlParams(String menuName, boolean needsAmpersand) {
        Object additionalString = "";
        if (menuName != null && !menuName.equals("")) {
            additionalString = (needsAmpersand ? "&" : "") + "menuName=" + menuName;
        }
        return additionalString;
    }

    @PostMapping(value={"edit"})
    public String edit(@Validated E f, BindingResult result, Model model, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare((SplibWebToolForm)f, model, this.functionName + "Edit", result, true);
        this.getService().edit((SplibWebToolEditForm)f, loginUser);
        return "redirect:" + (String)(this.editSuccessRedirectPath == null ? "/" + this.functionName + "/search?success" : this.editSuccessRedirectPath) + this.getUrlParams(((SplibWebToolForm)f).getMenuName(), true);
    }

    @PostMapping(value={"edit"}, params={"back"})
    public String back(@Validated E f, BindingResult result, Model model) {
        return "redirect:/" + this.functionName + "/search?" + this.getUrlParams(((SplibWebToolForm)f).getMenuName(), false);
    }

    @PostMapping(value={"edit"}, params={"updateDropDown=true"})
    public String updateOptions(E f, Model model) throws Exception {
        this.prepare((SplibWebToolForm)f, model, this.functionName + "Edit", null, false);
        model.addAttribute(this.functionName + "EditForm", f);
        return this.functionName + "Edit";
    }

    protected void prepare(SplibWebToolForm form, Model model, String nextPageOnError, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        SplibWebToolExceptionHandlerData info = new SplibWebToolExceptionHandlerData((SplibWebToolController<? extends SplibWebToolSearchConditionForm, ? extends SplibWebToolEditForm>)this, form, nextPageOnError);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        if (form instanceof SplibWebToolEditForm) {
            this.prepareEditForm((SplibWebToolEditForm)form);
        }
        this.commonProc(form, model, result, needsValidationCheck);
    }

    protected void prepareEditForm(SplibWebToolEditForm form) {
        this.getService().prepareEditForm(form);
    }

    protected void prepare(SplibWebToolForm form, Model model, String nextPageOnError) throws InputValidationException, AppException {
        this.prepare(form, model, nextPageOnError, null, false);
    }

    protected void prepareWithMovingToListOnError(BindingResult result, SplibWebToolForm form, Model model) throws InputValidationException, AppException {
        SplibWebToolExceptionHandlerData info = new SplibWebToolExceptionHandlerData(this, form);
        this.request.setAttribute("ecuacion.spring.mvc.infoForErrorHandling", (Object)info);
        this.commonProc(form, model, result, false);
    }

    protected void prepareWithMovingToListOnError(SplibWebToolForm form, Model model) throws InputValidationException, AppException {
        this.prepareWithMovingToListOnError(null, form, model);
    }

    private void commonProc(SplibWebToolForm form, Model model, BindingResult result, boolean needsValidationCheck) throws InputValidationException, AppException {
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                SplibWebToolExceptionHandlerData info = (SplibWebToolExceptionHandlerData)this.request.getAttribute("ecuacion.spring.mvc.infoForErrorHandling");
                info.setNextPageOnError(null);
                String msgId = "jp.ecuacion.splib.web.tool.common.message.tokenInvalidate";
                throw new CustomizedValidationAppException(msgId);
            }
            tokenSet.remove(tokenFromHtml);
        }
        if (needsValidationCheck) {
            boolean hasNotEmptyError = false;
            if (form instanceof SplibWebToolEditForm) {
                SplibWebToolEditForm f = (SplibWebToolEditForm)form;
                hasNotEmptyError = f.hasNotEmptyError();
            }
            if (hasNotEmptyError || result != null && result.hasErrors()) {
                throw new InputValidationException(form);
            }
        }
    }

    static class NullSupportCustomBooleanEditor
    extends CustomBooleanEditor {
        public NullSupportCustomBooleanEditor() {
            super(false);
        }

        public void setAsText(@Nullable String text) throws IllegalArgumentException {
            if (text == null || text.equals("") || text.equals("null")) {
                this.setValue(null);
                return;
            }
            List<String> list = Arrays.asList((text = text.trim()).split(","));
            if (list.size() > 1) {
                if (list.size() > 2) {
                    throw new RuntimeException("Unpresumable.");
                }
                Collections.sort(list);
                if (!list.get(0).equalsIgnoreCase("OFF") || !list.get(1).equalsIgnoreCase("ON")) {
                    throw new RuntimeException("Unpresumable.");
                }
                this.setValue(Boolean.TRUE);
                return;
            }
            super.setAsText(text);
        }
    }
}

