package jp.ecuacion.splib.web.tool.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.MailUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;

public class SplibWebToolUtil {
  
  /** offsetはlogin画面でのonload時に呼ばれるため、login画面を開いた状態で放置した場合は値がnullでエラーになる。 */
  public DatetimeFormatParameters getParams(HttpServletRequest request) {
    DatetimeFormatParameters params = new DatetimeFormatParameters();
    String strOffset = (String) request.getSession().getAttribute("zoneOffset");
    
    // イレギュラーな挙動により、strOffsetがnullの場合は発生してしまう。
    // （システムエラーで、userDetailはsessionに持っているのにlogin画面に戻る場合など）
    // その場合、次の処理がnull引数でエラーとなるためnullならUtc（0）を入れておく。
    // ログインしていない画面で時間を表示することもないだろうから問題ないと思われる
    if (strOffset == null) strOffset = "0";
    
    params.setZoneOffsetWithJsMinutes(Integer.valueOf(strOffset));
    
    return params;
  }
  
  public void sendMailOnSystemErrorFromSettingsInApplicationProperties(Throwable th) {


    List<String> errorMailAddressList =
        Arrays.asList(PropertyFileUtil.getApp("MAIL_SYSTEM_ERROR_CSV_LIST").split(","));
    
    // エラー内容をメールで送信
    try {
      if (errorMailAddressList == null || errorMailAddressList.size() == 0) {
        return;
      }

      // メールする。メールができない状況にあった場合はどうしようもないので握りつぶす
      try {
        new MailUtil().sendErrorMail(th, errorMailAddressList);
      } catch (Exception ex) {
        ex.printStackTrace();
      }
      
    } catch (Throwable th1) {
      // ログに出力
      try {
        new LogUtil().logErr(th1);
        
      } catch (Throwable th2) {
        // ここまでくるとどうにもならないので標準出力に出力。それもダメなら何もしない
        try {
          th1.printStackTrace();
        } catch (Throwable th3) {
          // 何もしない
        }
      }
    }
  }
}
