package jp.ecuacion.splib.web.tool.form.record;

public class StringMatchingConditionBean {

  /** 検索項目の文字列検索パターンを示す。 */
  private StringMatchingPatternEnum stringSearchPatternEnum;

  /** 検索項目の文字列検索での大文字・小文字の区別を指定。 */
  private boolean ignoresCase;

  public StringMatchingConditionBean() {
    this.stringSearchPatternEnum = StringMatchingPatternEnum.PARTIAL;
    this.ignoresCase = true;
  }

  public StringMatchingConditionBean(StringMatchingPatternEnum stringSearchPatternEnum) {
    this.stringSearchPatternEnum = stringSearchPatternEnum;
    this.ignoresCase = true;
  }

  public StringMatchingConditionBean(StringMatchingPatternEnum stringSearchPatternEnum,
      boolean ignoresCase) {
    this.stringSearchPatternEnum = stringSearchPatternEnum;
    this.ignoresCase = ignoresCase;
  }

  public StringMatchingPatternEnum getStringSearchPatternEnum() {
    return stringSearchPatternEnum;
  }

  public boolean isIgnoresCase() {
    return ignoresCase;
  }

  public static enum StringMatchingPatternEnum {
    EXACT, PARTIAL, PREFIX, POSTFIX
  }
}
