package jp.ecuacion.splib.web.tool.controller;

import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class SplibWebToolLoginController {
  
  /**
   * Session Timeout状態で、ログインボタンや他のPOST系ボタンを押す場合、session timeoutで弾かれ
   * /public/login/accessDeined にredirectされるが、そのredirectもPOSTで行われるため
   * 本処理にPOSTで入ってくることがある。それを考慮し@RequestMappingにしておく。
   */
  @RequestMapping("/public/login")
  public String login(Model model) throws CustomizedValidationAppException {
    return "login";
  }
}
