package jp.ecuacion.splib.web.tool.bean;

/** recordの中で定義され、record内の各属性のhtml上での表示・挙動を制御するための情報を保持。 */
public class HtmlItem {

  /** 
   * fieldName。"accId", "accGroup.id"など、「acc.」などのrootRecordFieldNameは外した形で定義。
   * そもそもrootRecordに定義するものなので、この形が自然だし効率的。
   */
  protected String itemName;

  /**
   * fieldNameに対するラベル表示を行うfield名を指定。"accName", "accGroup.name"などの形で定義。
   * 尚、こちらも「acc.」などのrootRecordFieldNameは外した形で定義。
   * 詳細はRecordInterface#getLabelItemName() を参照。
   */
  protected String labelItemName;
  
  /** 登録・更新時に入力必須かを示す。itemの種類によらず共通。 */
  protected boolean isNotEmpty;

  /** labelFieldNameのみ指定したい場合に使用。 */
  public HtmlItem(String itemName, String labelItemName) {
    this.itemName = itemName;
    this.labelItemName = labelItemName;
  }

  public HtmlItem(String itemName, boolean isNotEmpty) {
    this.itemName = itemName;
    this.isNotEmpty = isNotEmpty;
  }

  public HtmlItem(String itemName, String labelItemName, boolean isNotEmpty) {
    this.itemName = itemName;
    this.labelItemName = labelItemName;
    this.isNotEmpty = isNotEmpty;
  }

  public String getItemName() {
    return itemName;
  }

  public String getLabelItemName() {
    return labelItemName;
  }

  public boolean getIsNotEmpty() {
    return isNotEmpty;
  }
}
