package jp.ecuacion.splib.web.tool.advice;

import jp.ecuacion.splib.web.tool.controller.SplibWebToolController;
import jp.ecuacion.splib.web.tool.form.SplibWebToolEditForm;
import jp.ecuacion.splib.web.tool.form.SplibWebToolForm;
import jp.ecuacion.splib.web.tool.form.SplibWebToolSearchConditionForm;

public class SplibWebToolExceptionHandlerData {

  private String nextPageOnError;

  private SplibWebToolController<? extends SplibWebToolSearchConditionForm, ? extends SplibWebToolEditForm> controller;

  private SplibWebToolForm form;

  /** validationを使用しない画面もあるため、defaultはfalseとしておく */
  private boolean usesSpringMvcValidationError;

  /** 遷移後の画面としてlist()を呼び出す場合に使用 */
  public SplibWebToolExceptionHandlerData(
      SplibWebToolController<? extends SplibWebToolSearchConditionForm, ? extends SplibWebToolEditForm> controller,
      SplibWebToolForm form) {
    this(controller, form, false);
  }

  /** 遷移後の画面としてlist()を呼び出す場合に使用 */
  public SplibWebToolExceptionHandlerData(
      SplibWebToolController<? extends SplibWebToolSearchConditionForm, ? extends SplibWebToolEditForm> controller,
      SplibWebToolForm form, boolean usesSpringMvcValidationError) {
    this.controller = controller;
    this.usesSpringMvcValidationError = usesSpringMvcValidationError;
    this.form = form;
  }

  /** 遷移後の画面としてnextPageOnErrorを呼び出す場合に使用 */
  public SplibWebToolExceptionHandlerData(
      SplibWebToolController<? extends SplibWebToolSearchConditionForm, ? extends SplibWebToolEditForm> controller,
      SplibWebToolForm form, String nextPageOnError) {
    this(controller, form, nextPageOnError, false);
  }

  /** 遷移後の画面としてnextPageOnErrorを呼び出す場合に使用 */
  public SplibWebToolExceptionHandlerData(
      SplibWebToolController<? extends SplibWebToolSearchConditionForm, ? extends SplibWebToolEditForm> controller,
      SplibWebToolForm form, String nextPageOnError, boolean usesSpringMvcValidationError) {
    this.controller = controller;
    this.nextPageOnError = nextPageOnError;
    this.usesSpringMvcValidationError = usesSpringMvcValidationError;
    this.form = form;
  }

  public String getNextPageOnError() {
    return nextPageOnError;
  }

  public void setNextPageOnError(String nextPageOnError) {
    this.nextPageOnError = nextPageOnError;
  }

  public SplibWebToolController<? extends SplibWebToolSearchConditionForm, ? extends SplibWebToolEditForm> getController() {
    return controller;
  }

  public SplibWebToolForm getForm() {
    return form;
  }

  public boolean getUsesSpringMvcValidationError() {
    return usesSpringMvcValidationError;
  }
}
