package jp.ecuacion.splib.web.tool.advice;

import jakarta.servlet.http.HttpServletRequest;
import jp.ecuacion.splib.web.tool.bean.RequestResultBean;
import jp.ecuacion.splib.web.tool.bean.SplibWebToolModelAttributes;
import jp.ecuacion.splib.web.tool.util.TransactionTokenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class SplibWebToolControllerAdvice {
  public static final String REQUEST_KEY_MODEL = "REQUEST_KEY_MODEL";

  @Autowired
  protected HttpServletRequest request;

  @Autowired
  private SplibWebToolModelAttributes modelAttr;

  @ModelAttribute
  public void setObjectsToModel(Model model) {
    // あらかじめmodelにmessagesを追加
    model.addAttribute(RequestResultBean.key, new RequestResultBean());
    
    // modelをsessionに追加。adviceのExceptionHandlerでModelを使いたいのだが、
    // そこでmodelをDIで取得すると中身が空っぽのModelが取得されるため。
    request.setAttribute(REQUEST_KEY_MODEL, model);

    // transactionToken
    model.addAttribute(TransactionTokenUtil.SESSION_KEY_TRANSACTION_TOKEN,
        new TransactionTokenUtil().issueNewToken(request));

    // 個別appの中で、全画面共通で使用したいparameterを設定。
    model.addAttribute("needsBootstrapBgGradient", modelAttr.getIsNeedsBootstrapBgGradient());
    model.addAttribute("bootstrapDarkMode", modelAttr.getBootstrapDarkMode());
  }
}
