package jp.ecuacion.splib.web.advice;

import jakarta.servlet.http.HttpServletRequest;
import jp.ecuacion.splib.web.bean.RequestResultBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class SplibWebControllerAdvice {
  public static final String REQUEST_KEY_MODEL = "REQUEST_KEY_MODEL";
  
  @Autowired
  protected HttpServletRequest request;

  @ModelAttribute
  public void setObjectsToModel(Model model) {
    // あらかじめmodelにmessagesを追加
    model.addAttribute(RequestResultBean.key, new RequestResultBean());
    
    // modelをsessionに追加。adviceのExceptionHandlerでModelを使いたいのだが、
    // そこでmodelをDIで取得すると中身が空っぽのModelが取得されるため。
    request.setAttribute(REQUEST_KEY_MODEL, model);
  }
}
