/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.exceptionhandler;

import jakarta.servlet.http.HttpServletRequest;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.exceptionhandler.SpringMvcExceptionHandlerData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class SpringMvcExceptionHandler {
    public static final String INFO_FOR_ERROR_HANDLING = "ecuacion.spring.mvc.infoForErrorHandling";
    @Autowired
    HttpServletRequest request;

    private SpringMvcExceptionHandlerData getInfo() {
        return (SpringMvcExceptionHandlerData)this.request.getAttribute(INFO_FOR_ERROR_HANDLING);
    }

    @ExceptionHandler(value={InputValidationException.class})
    public ModelAndView handleInputValidationException(InputValidationException exception) {
        SpringMvcExceptionHandlerData info = this.getInfo();
        return this.common(info);
    }

    @ExceptionHandler(value={AppException.class})
    public ModelAndView handleAppException(AppException exception) {
        SpringMvcExceptionHandlerData info = this.getInfo();
        info.getModel().addAttribute("message", (Object)new ExceptionUtil().getMessage((Throwable)exception, null, false));
        return this.common(info);
    }

    private ModelAndView common(SpringMvcExceptionHandlerData info) {
        String returnPage = null;
        returnPage = info.getNextPageOnError() == null ? info.getController().list(info.getModel()) : info.getNextPageOnError();
        return new ModelAndView(returnPage, info.getModel().asMap());
    }
}

