package jp.ecuacion.splib.web.exceptionhandler;

import jakarta.servlet.http.HttpServletRequest;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.splib.web.exception.InputValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class SpringMvcExceptionHandler {

  public static final String INFO_FOR_ERROR_HANDLING = "ecuacion.spring.mvc.infoForErrorHandling";
  @Autowired
  HttpServletRequest request;

  private SpringMvcExceptionHandlerData getInfo() {
    return (SpringMvcExceptionHandlerData) request.getAttribute(INFO_FOR_ERROR_HANDLING);
  }

  @ExceptionHandler({InputValidationException.class})
  public ModelAndView handleInputValidationException(InputValidationException exception) {
    SpringMvcExceptionHandlerData info = getInfo();

    return common(info);
  }

  @ExceptionHandler({AppException.class})
  public ModelAndView handleAppException(AppException exception) {
    SpringMvcExceptionHandlerData info = getInfo();

    info.getModel().addAttribute("message",
        new ExceptionUtil().getMessage(exception, null, false));

    return common(info);
  }

  private ModelAndView common(SpringMvcExceptionHandlerData info) {
    
    String returnPage = null;
    //一覧画面での更新処理の場合は、一覧取得処理を呼び出し
    if (info.getNextPageOnError() == null) {
      returnPage = info.getController().list(info.getModel());

    } else {
      returnPage = info.getNextPageOnError();
    }

    return new ModelAndView(returnPage, info.getModel().asMap());
  }
}
