/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.bean;

import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public class HtmlItem {
    protected String itemName;
    protected String labelItemName;
    protected AuthInfoContainer<Boolean> isNotEmpty = new AuthInfoContainer<Boolean>(false);

    public HtmlItem(String itemName) {
        this.itemName = itemName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public HtmlItem labelItemName(String labelItemName) {
        this.labelItemName = labelItemName;
        return this;
    }

    public String getLabelItemName() {
        return this.labelItemName;
    }

    public HtmlItem isNotEmpty(boolean isNotEmpty) {
        this.isNotEmpty.setDefaultValue(isNotEmpty);
        return this;
    }

    public HtmlItem isNotEmpty(AuthKindEnum authKind, String authString, boolean isNotEmpty) {
        this.isNotEmpty.add(new AuthInfo<Boolean>(authKind, authString, isNotEmpty));
        return this;
    }

    public boolean getIsNotEmpty(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.isNotEmpty.getValue(loginState, bean);
    }

    public static class AuthInfoContainer<T> {
        private List<AuthInfo<T>> list = new ArrayList<AuthInfo<T>>();
        private T defaultValue;

        public AuthInfoContainer(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void add(AuthInfo<T> authInfo) {
            this.getList().add(authInfo);
        }

        public List<AuthInfo<T>> getList() {
            return this.list;
        }

        public void setList(List<AuthInfo<T>> list) {
            this.list = list;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getValue(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
            if (this.list == null) {
                this.list = new ArrayList<AuthInfo<T>>();
            }
            for (AuthInfo<T> info : this.list) {
                if (info.getAuthKind() == AuthKindEnum.loginState) {
                    if (!info.getAuthString().equals(loginState)) continue;
                    return info.getValue();
                }
                if (info.getAuthKind() == AuthKindEnum.role) {
                    if (!bean.getRoleList().contains(info.getAuthString())) continue;
                    return info.getValue();
                }
                if (info.getAuthKind() == AuthKindEnum.authority) {
                    if (!bean.getAuthorityList().contains(info.getAuthString())) continue;
                    return info.getValue();
                }
                throw new RuntimeException("Set appropriate one of the AuthKindEnum values");
            }
            return this.defaultValue;
        }
    }

    public static class AuthInfo<T> {
        private AuthKindEnum authKind;
        private String authString;
        private T value;

        public AuthInfo(AuthKindEnum authKind, String authString, T value) {
            this.authKind = authKind;
            this.authString = authString;
            this.value = value;
        }

        public AuthKindEnum getAuthKind() {
            return this.authKind;
        }

        public void setAuthKind(AuthKindEnum authKind) {
            this.authKind = authKind;
        }

        public String getAuthString() {
            return this.authString;
        }

        public void setAuthString(String authString) {
            this.authString = authString;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }

    public static enum AuthKindEnum {
        loginState,
        role,
        authority;

    }
}

