/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnAppExceptionBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnSuccessBean;
import jp.ecuacion.splib.web.controller.SplibGeneral2FormsController;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibSearchListController<FST extends SplibSearchForm, FLT extends SplibListForm<?>, S extends SplibSearchListService<FST, FLT>>
extends SplibGeneral2FormsController<FST, FLT, S> {
    @Autowired
    private FST newSearchForm;

    public SplibSearchListController(@Nonnull String function) {
        this(function, new SplibGeneralController.ControllerContext());
    }

    public SplibSearchListController(@Nonnull String function, SplibGeneralController.ControllerContext settings) {
        super(function, settings.subFunction("searchList"));
    }

    @Override
    public String getDefaultSubFunctionOnSuccess() {
        return "searchList";
    }

    @Override
    public String submitOnChangeToRefresh(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.getProperSearchForm(model, searchForm);
        super.submitOnChangeToRefresh(model, searchForm, listForm, loginUser);
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean("searchList", "page"));
    }

    @Override
    public String page(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        searchForm = this.getProperSearchForm(model, searchForm);
        ((SplibGeneralForm)listForm).setDataKind(((SplibGeneralForm)searchForm).getDataKind());
        this.redirectUrlOnAppExceptionBean = new RedirectUrlPageOnAppExceptionBean();
        this.prepare(model, loginUser, new SplibGeneralForm[]{searchForm, listForm});
        ((SplibSearchListService)this.getService()).page(searchForm, listForm, loginUser);
        return this.getReturnStringToShowPage();
    }

    @GetMapping(value={"action"}, params={"search"})
    public String search(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        return this.page(model, searchForm, listForm, loginUser);
    }

    @GetMapping(value={"action"}, params={"action=searchAgain"})
    public String searchAgain(Model model, FST searchForm, @AuthenticationPrincipal UserDetails loginUser, FLT listForm) throws Exception {
        return this.search(model, searchForm, listForm, loginUser);
    }

    protected FST getProperSearchForm(Model model, FST searchForm) {
        String formName = this.getFunction() + "SearchForm";
        String key = this.getSessionKey(formName, searchForm);
        if (searchForm != null) {
            if (((SplibSearchForm)searchForm).isRequestFromSearchForm()) {
                this.request.getSession().setAttribute(key, searchForm);
            }
            if (this.request.getSession().getAttribute(key) == null) {
                this.request.getSession().setAttribute(key, searchForm);
            }
        } else if (this.request.getSession().getAttribute(formName) == null) {
            throw new RuntimeException("f == null cannot be occurred.");
        }
        SplibSearchForm formUsedForSearch = (SplibSearchForm)this.request.getSession().getAttribute(this.getSessionKey(formName, searchForm));
        return (FST)formUsedForSearch;
    }

    private String getSessionKey(String formName, FST searchForm) {
        return formName + (String)(searchForm == null || ((SplibGeneralForm)searchForm).getDataKind() == null || ((SplibGeneralForm)searchForm).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)searchForm).getDataKind());
    }

    @GetMapping(value={"action"}, params={"conditionClear"})
    public String searchConditionClear(Model model, FST searchForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        String formName = this.getFunction() + "SearchForm";
        String sessionKey = formName + (String)(((SplibGeneralForm)searchForm).getDataKind() == null || ((SplibGeneralForm)searchForm).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)searchForm).getDataKind());
        this.request.getSession().setAttribute(sessionKey, this.newSearchForm);
        this.prepare(model, loginUser, new SplibGeneralForm[0]);
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean().noSuccessMessage().putParam("dataKind", ((SplibGeneralForm)searchForm).getDataKind()));
    }

    @PostMapping(value={"action"}, params={"delete"})
    public String delete(Model model, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, loginUser, new SplibGeneralForm[]{listForm});
        ((SplibSearchListService)this.getService()).delete(listForm, loginUser);
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean().putParam("dataKind", ((SplibGeneralForm)listForm).getDataKind()));
    }

    @PostMapping(value={"action"}, params={"showInsertForm"})
    public String showInsertForm(Model model, @AuthenticationPrincipal UserDetails loginUser) throws InputValidationException, AppException {
        this.prepare(model, loginUser, new SplibGeneralForm[0]);
        RedirectUrlBean bean = new RedirectUrlPageOnSuccessBean("edit", "page").noSuccessMessage().putParamMap(this.request.getParameterMap());
        return this.getReturnStringOnSuccess(bean);
    }

    @PostMapping(value={"action"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model, @AuthenticationPrincipal UserDetails loginUser) throws InputValidationException, AppException {
        this.prepare(model, loginUser, new SplibGeneralForm[0]);
        RedirectUrlBean bean = new RedirectUrlPageOnSuccessBean("edit", "page").noSuccessMessage().putParamMap(this.request.getParameterMap());
        return this.getReturnStringOnSuccess(bean);
    }
}

