package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.List;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneral2FormsService;
import org.springframework.lang.NonNull;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

//@formatter:off
public abstract class SplibGeneral2FormsController
    <F1 extends SplibGeneralForm, F2 extends SplibGeneralForm, 
    S extends SplibGeneral2FormsService<F1, F2>> extends SplibGeneralController<S> {
  //@formatter:on

  // @Autowired
  // protected S service;

  // @Override
  // public S getService() {
  // return service;
  // }

  private StringUtil strUtil = new StringUtil();

  public SplibGeneral2FormsController(@Nonnull String function) {
    super(function);
  }

  /** functionを指定したconstructor。functionだけは必須なのでconstructorの引数としている。 */
  protected SplibGeneral2FormsController(@Nonnull String function,
      @NonNull ControllerContext settings) {
    super(function, settings);
  }

  @SuppressWarnings("unchecked")
  public void prepareForm(List<SplibGeneralForm> allFormList, UserDetails loginUser) {
    if (allFormList == null || allFormList.size() != 2) {
      throw new RuntimeException("The number of forms not match.");
    }

    SplibGeneralForm form1 = allFormList.get(0);
    SplibGeneralForm form2 = allFormList.get(1);
    getService().prepareForm((F1) form1, (F2) form2, loginUser);
  }

  /**
   * postした際にsession timeoutだった場合はlogin画面に戻されるがその際もPOST通信になる場合があるなど、 場面によりget/post両方ありうるので両方記載しておく。
   */
  @RequestMapping(value = "page", method = {RequestMethod.GET, RequestMethod.POST})
  public String page(Model model, F1 form1, F2 form2,
      @AuthenticationPrincipal UserDetails loginUser) throws Exception {
    prepare(model, loginUser, form1, form2);
    getService().page(form1, form2, loginUser);
    return getReturnStringToShowPage();
  }

  /** 場面によりget/post両方ありうるので両方記載しておく。 */
  @RequestMapping(value = "action", params = "submitOnChangeToRefresh=true",
      method = {RequestMethod.GET, RequestMethod.POST})
  public String submitOnChangeToRefresh(Model model, F1 form1, F2 form2,
      @AuthenticationPrincipal UserDetails loginUser) throws Exception {
    prepare(model, loginUser, form1, form2);
    getService().prepareForm(form1, form2, loginUser);
    return getFunction() + strUtil.capitalize(getSubFunction());
  }
}
