/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnSuccessBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathBean;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class SplibGeneralController<S extends SplibGeneralService>
extends SplibBaseController {
    public static final String KEY = "controller";
    protected RedirectUrlBean redirectUrlOnAppExceptionBean;
    protected ControllerContext context;
    protected SplibSecurityUtil.RolesAndAuthoritiesBean rolesAndAuthoritiesBean;
    @Autowired
    protected S service;
    @Autowired
    private SplibUtil util;
    private StringUtil strUtil = new StringUtil();

    public static ControllerContext newContext() {
        return new ControllerContext();
    }

    public S getService() {
        return this.service;
    }

    public SplibGeneralController(@Nonnull String function) {
        this(function, SplibGeneralController.newContext());
    }

    protected SplibGeneralController(@Nonnull String function, @NonNull ControllerContext context) {
        context.function(function);
        this.context = context;
    }

    public String getFunction() {
        return this.context.function();
    }

    public String getSubFunction() {
        return this.context.subFunction();
    }

    public String getRootRecordName() {
        return this.context.rootRecordName();
    }

    public RedirectUrlBean getRedirectUrlOnAppExceptionBean() {
        return this.redirectUrlOnAppExceptionBean;
    }

    @ModelAttribute
    private void setCommonParamsToModel(Model model, @AuthenticationPrincipal UserDetails loginUser) {
        model.addAttribute("function", (Object)this.context.function());
        model.addAttribute("rootRecordName", (Object)this.context.rootRecordName());
        this.rolesAndAuthoritiesBean = loginUser == null ? new SplibSecurityUtil().getRolesAndAuthoritiesBean() : new SplibSecurityUtil().getRolesAndAuthoritiesBean(loginUser);
        model.addAttribute("rolesAndAuthorities", (Object)this.rolesAndAuthoritiesBean);
    }

    protected String getReturnStringToShowPage() {
        return this.getDefaultHtmlFileName();
    }

    protected String getReturnStringToShowPage(String page) {
        return page;
    }

    protected String getReturnStringOnSuccess(RedirectUrlBean redirectUrlBean) {
        if (redirectUrlBean instanceof RedirectUrlPageBean) {
            return ((RedirectUrlPageBean)redirectUrlBean).getUrl(this.util.getLoginState(), this.context.function(), this.getDefaultSubFunctionOnSuccess(), this.getDefaultPageOnSuccess());
        }
        if (redirectUrlBean instanceof RedirectUrlPathBean) {
            return ((RedirectUrlPathBean)redirectUrlBean).getUrl();
        }
        throw new RuntimeException("RedirectUrlBean\u304c\u60f3\u5b9a\u5916\u306e\u5024\u3067\u3059\u3002" + String.valueOf(redirectUrlBean));
    }

    protected String getReturnStringOnSuccess() {
        return new RedirectUrlPageOnSuccessBean().getUrl(this.util.getLoginState(), this.context.function(), this.getDefaultSubFunctionOnSuccess(), this.getDefaultPageOnSuccess());
    }

    public String prepareForSuccessRedirectAndGetPath(Model model) {
        return this.prepareForRedirectOrForwardAndGetPath(new RedirectUrlPageOnSuccessBean(), model);
    }

    public String prepareForSuccessRedirectAndGetPath(Model model, String subFunction, String page) {
        return this.prepareForRedirectOrForwardAndGetPath(new RedirectUrlPageOnSuccessBean(subFunction, page), model);
    }

    public String prepareForForwardAndGetPath(Model model) {
        return this.prepareForRedirectOrForwardAndGetPath(new RedirectUrlPageBean(), model);
    }

    public String prepareForForwardAndGetPath(Model model, String subFunction, String page) {
        RedirectUrlPageBean redirectBean = (RedirectUrlPageBean)new RedirectUrlPageBean(subFunction, page).putParam("forwarded", (String)null);
        return this.prepareForRedirectOrForwardAndGetPath(redirectBean, model);
    }

    public String prepareForRedirectOrForwardAndGetPath(RedirectUrlPageBean redirectBean, Model model) {
        if (redirectBean.isForward()) {
            redirectBean.putParamMap(this.request.getParameterMap());
        }
        return this.util.prepareForRedirectAndGetPath(redirectBean, model != null, this, this.request, model);
    }

    @GetMapping(value={"action"})
    public void throw404() throws NoResourceFoundException {
        throw new NoResourceFoundException(HttpMethod.GET, "from SplibGeneralController");
    }

    public String getDefaultHtmlFileName() {
        return this.context.function() + this.strUtil.capitalize(this.context.htmlFilenamePostfix() == null ? this.context.subFunction() : this.context.htmlFilenamePostfix());
    }

    public String getDefaultSubFunctionOnSuccess() {
        return this.context.subFunction();
    }

    public String getDefaultSubFunctionOnAppException() {
        return this.context.subFunction();
    }

    public String getDefaultPageOnSuccess() {
        return "page";
    }

    public String getDefaultPageOnAppException() {
        return "page";
    }

    public void prepare(Model model, SplibGeneralForm ... forms) throws InputValidationException, AppException {
        this.prepare(model, new PrepareSettings(), forms);
    }

    public void prepare(Model model, PrepareSettings settings, SplibGeneralForm ... forms) throws InputValidationException, AppException {
        for (SplibGeneralForm form : forms) {
            model.addAttribute((Object)form);
            form.setControllerContext(this.context);
        }
        ((SplibGeneralService)this.getService()).prepareForm(new ArrayList<SplibGeneralForm>(Arrays.asList(forms)));
        this.request.setAttribute(KEY, (Object)this);
        this.transactionTokenCheck();
        for (SplibGeneralForm form : forms) {
            if (!form.getPrepareSettings().validates()) continue;
            this.validationCheck(form, form.getPrepareSettings().bindingResult(), this.util.getLoginState(), this.rolesAndAuthoritiesBean);
        }
    }

    protected void transactionTokenCheck() throws BizLogicAppException {
        String forward = this.request.getParameter("forward");
        if (forward != null && forward.equals("true")) {
            return;
        }
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                String msgId = "jp.ecuacion.splib.web.common.message.tokenInvalidate";
                throw new BizLogicAppException(msgId);
            }
            tokenSet.remove(tokenFromHtml);
        }
    }

    private void validationCheck(SplibGeneralForm form, BindingResult result, String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) throws InputValidationException {
        boolean hasNotEmptyError = false;
        hasNotEmptyError = form.hasNotEmptyError(loginState, bean);
        if (hasNotEmptyError || result != null && result.hasErrors()) {
            throw new InputValidationException(form);
        }
    }

    public static class ControllerContext {
        protected String function;
        protected String subFunction = "";
        protected String htmlFilenamePostfix;
        protected String rootRecordName;

        ControllerContext() {
        }

        public ControllerContext function(String function) {
            this.function = function;
            return this;
        }

        public String function() {
            return this.function;
        }

        public ControllerContext subFunction(String subFunction) {
            this.subFunction = subFunction;
            return this;
        }

        public String subFunction() {
            return this.subFunction;
        }

        public ControllerContext htmlFilenamePostfix(String htmlFilenamePostfix) {
            this.htmlFilenamePostfix = htmlFilenamePostfix;
            return this;
        }

        public String htmlFilenamePostfix() {
            return this.htmlFilenamePostfix;
        }

        public ControllerContext rootRecordName(String rootRecordName) {
            this.rootRecordName = rootRecordName;
            return this;
        }

        public String rootRecordName() {
            return this.rootRecordName == null ? this.function : this.rootRecordName;
        }
    }

    public static class PrepareSettings {
    }
}

