package jp.ecuacion.splib.web.service;

import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.splib.web.form.SplibEditForm;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class SplibEditService<F extends SplibEditForm>
    extends SplibGeneral1FormService<F> {

  @Override
  public void page(F editForm, UserDetails loginUser) throws Exception {
    
    if (editForm.isInsert() == null) {
      throw new RuntimeException("splibEditForm.isInsert() must not be null.");

    } else if (editForm.isInsert()) {
      getInsertPage(editForm, loginUser);

    } else {
      getUpdatePage(editForm, loginUser);
    }
  }

  public abstract void getInsertPage(F editForm, UserDetails loginUser)
      throws AppException;

  /**
   * 引数のformは、listから選択された行のidとversionを受け取るためのformとしてたまたまeditFormを使用しているのみ。
   * そのidを元にレコード全体を取得したものを改めてeditFormとして戻す。
   */
  public abstract void getUpdatePage(F editForm, UserDetails loginUser)
      throws Exception;

  public abstract void edit(F editForm, UserDetails loginUser) throws Exception;

  /** edit時にinsertかupdateかを判別する方法。小さな処理だが共通化しておく。 */
  protected boolean isInsert(String id) {
    return id == null || id.equals("");
  }
}
