package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.List;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneral1FormService;
import org.springframework.lang.NonNull;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

//@formatter:off
public abstract class SplibGeneral1FormController
    <F extends SplibGeneralForm, S extends SplibGeneral1FormService<F>>
    extends SplibGeneralController<S> {
  //@formatter:on

  @Override
  public S getService() {
    return service;
  }
  
  private StringUtil strUtil = new StringUtil();

  public SplibGeneral1FormController(@Nonnull String function) {
    super(function);
  }
  
  /** functionを指定したconstructor。functionだけは必須なのでconstructorの引数としている。 */
  protected SplibGeneral1FormController(@Nonnull String function,
      @NonNull ControllerContext settings) {
    super(function, settings);
  }

  @SuppressWarnings("unchecked")
  public void prepareForm(List<SplibGeneralForm> allFormList) {
    if (allFormList == null || allFormList.size() != 1) {
      throw new RuntimeException("The number of forms not match.");
    }
    
    SplibGeneralForm form = allFormList.get(0);
    getService().prepareForm((F) form);
  }

  @GetMapping("page")
  public String page(Model model, F form, @AuthenticationPrincipal UserDetails loginUser)
      throws Exception {
    prepare(model, form);
    getService().page(form, loginUser);
    return getReturnStringToShowPage();
  }

  /** 場面によりget/post両方ありうるので両方記載しておく。 */
  @RequestMapping(value = "action", params = "submitOnChangeToRefresh=true",
      method = {RequestMethod.GET, RequestMethod.POST})
  public String submitOnChangeToRefresh(Model model, F form) throws Exception {
    prepare(model, form);
    model.addAttribute(getFunction() + strUtil.capitalize(getSubFunction()) + "Form", form);
    getService().prepareForm(form);
    return getFunction() + strUtil.capitalize(getSubFunction());
  }
}
