/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.advice;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import jp.ecuacion.splib.web.bean.MessagesBean;
import jp.ecuacion.splib.web.bean.SplibModelAttributes;
import jp.ecuacion.splib.web.util.SplibUtil;
import jp.ecuacion.splib.web.util.internal.TransactionTokenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class SplibControllerAdvice {
    public static final String REQUEST_KEY_MODEL = "REQUEST_KEY_MODEL";
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    private SplibModelAttributes modelAttr;
    @Autowired
    SplibUtil util;

    @ModelAttribute
    public void setObjectsToModel(Model model) {
        this.request.setAttribute(REQUEST_KEY_MODEL, (Object)model);
        this.recoverRequestParametersFromRedirectContextId(model);
        this.prepareRedirectContextId(model);
        model.addAttribute("transactionToken", (Object)new TransactionTokenUtil().issueNewToken(this.request));
        model.addAttribute("loginState", (Object)this.util.getLoginState());
        this.modelAttr.addAllToModel(model);
    }

    private void recoverRequestParametersFromRedirectContextId(Model model) {
        String contextId = this.request.getParameter("contextId");
        if (contextId != null && !contextId.equals("")) {
            HashMap modelMap;
            Map messageBeanMap = (Map)this.request.getSession().getAttribute("messagesMapKey");
            if (messageBeanMap != null && messageBeanMap.get(contextId) != null) {
                model.addAttribute("responseMessages", messageBeanMap.get(contextId));
                messageBeanMap.clear();
            }
            if ((modelMap = (HashMap)this.request.getSession().getAttribute("modelMapKey")) != null && modelMap.get(contextId) != null) {
                Map modelMapRedirectFrom = ((Model)modelMap.get(contextId)).asMap();
                modelMapRedirectFrom.remove("responseMessages");
                model.addAllAttributes(modelMapRedirectFrom);
                modelMap.clear();
            }
        }
        if (!model.containsAttribute("responseMessages")) {
            model.addAttribute("responseMessages", (Object)new MessagesBean());
        }
    }

    private void prepareRedirectContextId(Model model) {
        String contextId = UUID.randomUUID().toString();
        this.request.getSession().setAttribute("contextId", (Object)contextId);
        HashMap<String, MessagesBean> messagesMap = (HashMap<String, MessagesBean>)this.request.getSession().getAttribute("messagesMapKey");
        if (messagesMap == null) {
            messagesMap = new HashMap<String, MessagesBean>();
            this.request.getSession().setAttribute("messagesMapKey", messagesMap);
        }
        MessagesBean requestResult = (MessagesBean)model.getAttribute("responseMessages");
        messagesMap.put(contextId.toString(), requestResult);
        HashMap modelMap = (HashMap)this.request.getSession().getAttribute("modelMapKey");
        if (modelMap == null) {
            modelMap = new HashMap();
            this.request.getSession().setAttribute("modelMapKey", modelMap);
        }
    }
}

