package jp.ecuacion.splib.web.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class RequestResultBean {
  public static final String key = "result";

//  private List<String> infoMessages = new ArrayList<>();

  private List<String> warnMessageList = new ArrayList<>();

  /**
   * spring mvc標準のbean validationのエラー処理を使用しない場合に使用する。 並び順を保持するためにListを使用。
   */
  private List<ErrorMessageBean> errorMessageList = new ArrayList<>();

  private List<String> getErrorMessageList(String itemName) {
    List<String> returnList = new ArrayList<>();

    for (ErrorMessageBean bean : errorMessageList) {
      if (bean.getItemNameSet().contains(itemName)) {
        returnList.add(bean.message);
      }
    }

    return returnList;
  }


  public RequestResultBean(Locale locale) {
  }

//  public List<String> getInfoMessages() {
//    return infoMessages;
//  }
//
//  public void setInfoMessages(List<String> infoMessages) {
//    this.infoMessages = infoMessages;
//  }

  public List<String> getWarnMessages() {
    return warnMessageList;
  }

  public void setWarnMessages(List<String> warnMessages) {
    this.warnMessageList = warnMessages;
  }

  public void setErrorMessage(String message) {
    errorMessageList.add(new ErrorMessageBean(message));
  }

  public void setErrorMessage(String message, String... itemName) {
    errorMessageList.add(new ErrorMessageBean(message, itemName));
  }

  /**
   * 全てのエラーを取得
   */
  public List<String> getErrorMessages() {
    List<String> rtnList = new ArrayList<>();

    for (ErrorMessageBean bean : errorMessageList) {
      rtnList.add(bean.getMessage());
    }

    return rtnList;
  }

  /**
   * 指定されたitemに対する全てのエラーを取得
   */
  public List<String> getErrorMessages(String itemName) {
    return getErrorMessageList(itemName);
  }

  /**
   * item指定のある全てのエラーを取得
   */
  public List<String> getErrorMessagesLinkedToItems() {
    return errorMessageList.stream()
        .filter(e -> e.getItemNameSet().size() > 0)
        .map(e -> e.getMessage())
        .collect(Collectors.toList());
  }

  /**
   * item指定のない全てのエラーを取得
   */
  public List<String> getErrorMessagesNotLinkedToItems() {
    return errorMessageList.stream()
        .filter(e -> e.getItemNameSet().size() == 0)
        .map(e -> e.getMessage())
        .collect(Collectors.toList());
  }

  public String isValid(String itemName) {
    return (getErrorMessageList(itemName).size() > 0) ? "is-invalid" : "";
  }

  /**
   * エラーメッセージとそのメッセージが指す項目をペアで持つ。 
   * bean validationのような単純にメッセージと項目が1:1となる場合ばかりではなく、
   * 相関チェックだと一つのエラーで複数の項目が対象となったり、対象項目が存在しないエラーなどもある。
   * それらを網羅して保持できるため、一つのメッセージと、0以上の項目をセットで保持できるbeanとする。
   */
  class ErrorMessageBean {
    private String message;

    private Set<String> itemNameSet = new HashSet<>();

    public ErrorMessageBean(String message) {
      this.message = message;
    }

    public ErrorMessageBean(String message, String... itemName) {
      this.message = message;
      this.itemNameSet =
          new HashSet<String>(Arrays.asList(itemName == null ? new String[] {} : itemName));
    }

    public String getMessage() {
      return message;
    }

    public Set<String> getItemNameSet() {
      return itemNameSet;
    }
  }
}
