/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Map;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnAppExceptionBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnSuccessBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathBean;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;

@Component
public class SplibUtil {
    @Autowired
    HttpServletRequest request;
    @Autowired
    private ServletContext servletContext;

    public DatetimeFormatParameters getParams(HttpServletRequest request) {
        DatetimeFormatParameters params = new DatetimeFormatParameters();
        String strOffset = (String)request.getSession().getAttribute("zoneOffset");
        if (strOffset == null) {
            strOffset = "0";
        }
        params.setZoneOffsetWithJsMinutes(Integer.valueOf(strOffset).intValue());
        return params;
    }

    public String getLoginState() {
        String tmp;
        Object loginState;
        String urlPathWithContextPath = this.request.getRequestURI();
        String contextPath = this.servletContext.getContextPath();
        if (!contextPath.equals("") && !contextPath.startsWith("/") || !urlPathWithContextPath.startsWith("/")) {
            throw new RuntimeException("servletContext.getContextPath() \u307e\u305f\u306f request.getRequestURI() \u304c\"\\\"\u304b\u3089\u59cb\u307e\u3063\u3066\u3044\u307e\u305b\u3093\u3002\u60f3\u5b9a\u5916\u3067\u3059\u3002servletContext.getContextPath() = " + contextPath + ", request.getRequestURI() = " + urlPathWithContextPath);
        }
        String urlPath = urlPathWithContextPath;
        if (!contextPath.equals("") && !contextPath.equals("/")) {
            urlPath = urlPath.replaceFirst(this.servletContext.getContextPath(), "");
        }
        if (((String)(loginState = (tmp = urlPath.substring(1)).substring(0, tmp.indexOf("/")))).equals("ecuacion")) {
            tmp = tmp.substring(tmp.indexOf("/") + 1);
            tmp = tmp.substring(0, tmp.indexOf("/"));
            loginState = (String)loginState + "-" + tmp;
        }
        ArrayList<String> loginStateCodeList = new ArrayList<String>();
        for (LoginStateEnum anEnum : LoginStateEnum.values()) {
            loginStateCodeList.add(anEnum.getCode());
        }
        if (!loginStateCodeList.contains(loginState)) {
            new RuntimeException("loginState not appropriate: loginState = " + (String)loginState + ", urlPath = " + urlPath);
        }
        return loginState;
    }

    public String prepareForSuccessRedirectAndGetPath(SplibGeneralController ctrl, HttpServletRequest request, Model model) {
        return this.prepareForRedirectAndGetPath(new RedirectUrlPageOnSuccessBean(ctrl.getDefaultPageOnSuccess()), true, ctrl, request, model);
    }

    public String prepareForRedirectAndGetPath(RedirectUrlBean redirectBean, boolean takesOverModel, SplibGeneralController ctrl, HttpServletRequest request, Model model) {
        String contextId = (String)request.getSession().getAttribute("contextId");
        Map modelMap = (Map)request.getSession().getAttribute("modelMapKey");
        if (redirectBean == null) {
            redirectBean = new RedirectUrlPageOnAppExceptionBean();
        }
        if (takesOverModel) {
            modelMap.put(contextId, model);
        }
        redirectBean.putParam("contextId", new String[]{contextId.toString()});
        String path = null;
        if (redirectBean instanceof RedirectUrlPageBean) {
            path = ((RedirectUrlPageBean)redirectBean).getUrl(this.getLoginState(), ctrl.getFunction(), ctrl.getDefaultSubFunctionOnAppException(), ctrl.getDefaultPageOnAppException());
        } else if (redirectBean instanceof RedirectUrlPathBean) {
            path = ((RedirectUrlPathBean)redirectBean).getUrl();
        } else {
            throw new RuntimeException("RedirectUrlBean\u304c\u60f3\u5b9a\u5916\u306e\u5024\u3067\u3059\u3002" + String.valueOf(redirectBean));
        }
        return path;
    }

    public static enum LoginStateEnum {
        PUBLIC("public"),
        ACCOUNT("account"),
        ADMIN("admin"),
        ECUACION_PUBLIC("ecuacion-public");

        private String code;

        private LoginStateEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

