/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.advice;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.AppWarningException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.BeanValidationUtil;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnAppExceptionBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathOnAppExceptionBean;
import jp.ecuacion.splib.web.bean.RequestResultBean;
import jp.ecuacion.splib.web.bean.SplibModelAttributes;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.exception.internal.HtmlFileNotFoundException;
import jp.ecuacion.splib.web.form.record.RecordInterface;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.http.HttpStatusCode;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class SplibExceptionHandler {
    public static final String INFO_FOR_ERROR_HANDLING = "ecuacion.spring.mvc.infoForErrorHandling";
    public static final String CONTEXT_ID = "CONTEXT_ID";
    public static final String REQUEST_RESULT_MAP_KEY = "REQUEST_RESULT_MAP_KEY";
    public static final String MODEL_MAP_KEY = "MODEL_MAP_KEY";
    private LogUtil logUtil = new LogUtil((Object)this);
    private DetailLogger detailLog = new DetailLogger((Object)this);
    @Autowired
    HttpServletRequest request;
    @Autowired
    SplibExceptionHandlerAction actionOnThrowable;
    @Autowired
    private SplibModelAttributes modelAttr;
    @Autowired
    private SplibUtil util;

    protected SplibGeneralController getController() {
        return (SplibGeneralController)this.request.getAttribute("controller");
    }

    private Model getModel() {
        return (Model)this.request.getAttribute("REQUEST_KEY_MODEL");
    }

    private String addFieldName(String message, String itemName) {
        return this.addFieldNames(message, new String[]{itemName});
    }

    private String addFieldNames(String message, String[] itemNames) {
        if (message.contains("{0}")) {
            message = MessageFormat.format(message, this.getItemNames(itemNames));
        }
        return message;
    }

    private String getItemNames(String[] itemNames) {
        StringBuilder sb = new StringBuilder();
        String prependParenthesis = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.prependParenthesis");
        String appendParenthesis = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.appendParenthesis");
        String separator = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.separator");
        boolean is1stTime = true;
        for (String itemName : itemNames) {
            if (PropertyFileUtil.hasFieldName((String)itemName)) {
                itemName = PropertyFileUtil.getFieldName((Locale)this.request.getLocale(), (String)itemName);
            }
            if (is1stTime) {
                is1stTime = false;
            } else {
                sb.append(separator);
            }
            sb.append(prependParenthesis + itemName + appendParenthesis);
        }
        return sb.toString();
    }

    @ExceptionHandler(value={AppWarningException.class})
    public ModelAndView handleAppWarningException(AppWarningException exception) throws Exception {
        RequestResultBean requestResult = (RequestResultBean)this.getModel().getAttribute("responseMessages");
        requestResult.setWarnMessage(exception.getMessageId(), PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)exception.getMessageId(), (String[])exception.getMessageArgs()), exception.getButtonId());
        return this.common(this.getController());
    }

    @ExceptionHandler(value={AppException.class})
    public ModelAndView handleAppException(AppException exception) throws Exception {
        RequestResultBean requestResult = (RequestResultBean)this.getModel().getAttribute("responseMessages");
        ArrayList<SingleAppException> exList = new ArrayList<SingleAppException>();
        if (exception instanceof MultipleAppException) {
            for (SingleAppException appEx : ((MultipleAppException)exception).getList()) {
                exList.add(appEx);
            }
            if (exList.size() == 0) {
                throw new RuntimeException("No exception included in MultipleAppException.");
            }
        } else {
            exList.add((SingleAppException)exception);
        }
        for (SingleAppException saex : exList) {
            String[] fields = null;
            if (saex instanceof BizLogicAppException && this.getController() instanceof SplibGeneralController) {
                BizLogicAppException ex = (BizLogicAppException)saex;
                fields = ex.getFields() == null ? new String[]{} : ex.getFields().getFields();
                ArrayList<Object> modifiedFieldList = new ArrayList<Object>();
                Objects.requireNonNull(fields);
                String prefix = this.getController().getRootRecordName() + ".";
                for (String field : fields) {
                    modifiedFieldList.add(field.startsWith(prefix) ? field : prefix + field);
                }
                fields = modifiedFieldList.toArray(new String[modifiedFieldList.size()]);
            }
            for (String message : new ExceptionUtil().getAppExceptionMessageList((AppException)saex, this.request.getLocale())) {
                message = this.addFieldNames(message, fields);
                requestResult.setErrorMessage(message, fields);
            }
        }
        return this.common(this.getController());
    }

    @ExceptionHandler(value={ObjectOptimisticLockingFailureException.class})
    public ModelAndView handleObjectOptimisticLockingFailureException(ObjectOptimisticLockingFailureException exception) throws Exception {
        return this.handleAppException((AppException)new BizLogicAppException("jp.ecuacion.splib.web.common.message.optimisticLocking"));
    }

    @ExceptionHandler(value={PessimisticLockingFailureException.class})
    public ModelAndView handlePessimisticLockingFailureException(PessimisticLockingFailureException exception) throws Exception {
        return this.handleAppException((AppException)new BizLogicAppException("jp.ecuacion.splib.web.common.message.pessimisticLocking"));
    }

    @ExceptionHandler(value={InputValidationException.class})
    public ModelAndView handleInputValidationException(InputValidationException exception, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        RequestResultBean requestResult = (RequestResultBean)this.getModel().getAttribute("responseMessages");
        List<ValidationErrorInfoBean> errorList = new BeanValidationUtil().validate((Object)exception.getForm(), this.request.getLocale()).stream().map(cv -> new ValidationErrorInfoBean((ConstraintViolation<?>)cv)).collect(Collectors.toList());
        errorList.addAll(exception.getForm().validateNotEmpty(this.request.getLocale(), this.util.getLoginState(), new SplibSecurityUtil().getRolesAndAuthoritiesBean(loginUser)).stream().collect(Collectors.toList()));
        errorList = errorList.stream().sorted(this.getComparator()).collect(Collectors.toList());
        this.removeDuplicatedValidators(errorList);
        if (errorList.size() == 0) {
            String msg = "SplibExceptionHandler#handleInputValidationException\u306b\u6765\u3066\u3044\u308b\u306e\u306berrorList\u306b\u30a8\u30e9\u30fc\u9805\u76ee\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\nrootRecoordName\u3068\u540c\u4e00\u306ename\u3092\u6301\u3063\u305fsubmit\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u305f\u5834\u5408\u306b\u767a\u751f\u3059\u308b\u6a21\u69d8\u3002\n\uff08\u4f8b\uff1arootRecordName\u3092app\u3068\u3057\u305f\u5834\u5408\u3001\u4ee5\u4e0b\u306e\u3088\u3046\u306a\u30dc\u30bf\u30f3\u3092\u4f5c\u6210\u3059\u308b\u5834\u5408\u306b\u767a\u751f\uff09\n<div th:replace=\"~{bootstrap/components :: commonPrimaryButton('app', ...)}\"></div>\n\ntext\u306a\u3069\u306e\u60c5\u5831\u306f\u3001GET\u3067\u3044\u3046\u3068\u3001request param\u306e\u4e2d\u3067\"app.desc=...\"\u306e\u3088\u3046\u306b\u8a18\u8f09\u3055\u308c\u308b\u304c\u3001\u305d\u306eparameter\u306e\u4e2d\u3067\nspring mvc\u3060\u3068\u30dc\u30bf\u30f3\u540d\u304c\"app=\"\u3068\u51fa\u308b\u3002\n\u3053\u306e\u30dc\u30bf\u30f3\u540d\u306b\u5bfe\u3059\u308b\"app=\"\u3092\u3001\"app\"\u306e\u30ad\u30fc\u30ef\u30fc\u30c9\u304c\u3042\u308b\u305f\u3081form\u3078\u306emapping\u5bfe\u8c61\u3060\u3068spring\u304c\u52d8\u9055\u3044\u3059\u308b\u305f\u3081\u306b\u3001\nmapping\u3092\u30c8\u30e9\u30a4\u3057\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u3066\u3044\u308b\u306e\u304b\u3082\u3002\n\uff08\u3061\u306a\u307f\u306b\u3001\u30dc\u30bf\u30f3\u306ename\u304cappzzz\u306a\u3069\u3001app\u304b\u3089\u59cb\u307e\u308b\u304capp\u3068\u306f\u7570\u306a\u308b\u6587\u5b57\u5217\u3067\u3042\u308c\u3070\u3001\u3053\u306e\u554f\u984c\u306f\u767a\u751f\u3057\u306a\u3044\uff09\n";
            throw new RuntimeException(msg);
        }
        for (ValidationErrorInfoBean cv2 : errorList) {
            String itemId;
            String message = cv2.getMessage();
            String itemName = itemId = cv2.getPropertyPath().toString();
            String recordName = itemName.substring(0, itemName.indexOf("."));
            itemName = ((RecordInterface)exception.getForm().getRootRecord(recordName)).getLabelItemName(recordName, itemName);
            message = this.addFieldName(message, itemName);
            requestResult.setErrorMessage(message, itemId);
        }
        if (this.getController() instanceof SplibGeneralController) {
            this.getController().getService().prepareForm(exception.getForm());
        }
        return this.common(this.getController());
    }

    private void removeDuplicatedValidators(List<ValidationErrorInfoBean> cvList) {
        HashMap duplicateCheckMap = new HashMap();
        HashSet<String> keySetWithNotEmpty = new HashSet<String>();
        for (ValidationErrorInfoBean cv : cvList) {
            String key = cv.getPropertyPath().toString();
            if (duplicateCheckMap.get(key) == null) {
                duplicateCheckMap.put(key, new HashSet());
            }
            ((Set)duplicateCheckMap.get(key)).add(cv);
            if (!this.isNotEmptyValidator(cv)) continue;
            keySetWithNotEmpty.add(key);
        }
        for (String key : keySetWithNotEmpty) {
            for (ValidationErrorInfoBean cv : (Set)duplicateCheckMap.get(key)) {
                if (this.isNotEmptyValidator(cv)) continue;
                cvList.remove(cv);
            }
        }
    }

    private boolean isNotEmptyValidator(ValidationErrorInfoBean cv) {
        String validatorClass = cv.getValidatorClass();
        return validatorClass.endsWith("NotEmpty") || validatorClass.endsWith("NotEmptyIfValid");
    }

    private Comparator<ValidationErrorInfoBean> getComparator() {
        return new Comparator<ValidationErrorInfoBean>(this){

            @Override
            public int compare(ValidationErrorInfoBean f1, ValidationErrorInfoBean f2) {
                int result = f1.getPropertyPath().toString().compareTo(f2.getPropertyPath().toString());
                if (result != 0) {
                    return result;
                }
                result = f1.getValidatorClass().compareTo(f2.getValidatorClass());
                if (result != 0) {
                    return result;
                }
                String s1 = f1.getAnnotationDescriptionString();
                String s2 = f2.getAnnotationDescriptionString();
                return s1.compareTo(s2);
            }
        };
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public String handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException exception, Model model) throws BizLogicAppException {
        this.logUtil.logErr((Throwable)exception, this.request.getLocale());
        this.actionOnThrowable.execute((Throwable)exception);
        return "redirect:/" + PropertyFileUtil.getApp((String)"jp.ecuacion.splib.web.system-error.go-to-path");
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    public void handleNoResourceFoundException(NoResourceFoundException exception, Model model) throws NoResourceFoundException {
        throw exception;
    }

    @ExceptionHandler(value={HtmlFileNotFoundException.class})
    ModelAndView handleHtmlFileNotFoundException(HtmlFileNotFoundException exception, Model model) throws NoResourceFoundException {
        this.detailLog.info("Designated html file not found. html file name = " + exception.getFileName());
        return new ModelAndView("redirect:/public/home/page");
    }

    @ExceptionHandler(value={Throwable.class})
    public ModelAndView handleThrowable(Throwable exception, Model model) {
        this.logUtil.logErr(exception, this.request.getLocale());
        this.actionOnThrowable.execute(exception);
        Model mdl = this.getModel() == null ? model : this.getModel();
        this.modelAttr.addAllToModel(mdl);
        return new ModelAndView("error", mdl.asMap(), HttpStatusCode.valueOf((int)500));
    }

    private ModelAndView common(SplibGeneralController ctrl) throws Exception {
        if (this.request.getSession().getAttribute(REQUEST_RESULT_MAP_KEY) == null) {
            this.request.getSession().setAttribute(REQUEST_RESULT_MAP_KEY, new HashMap());
        }
        HashMap messagesMap = (HashMap)this.request.getSession().getAttribute(REQUEST_RESULT_MAP_KEY);
        if (this.request.getSession().getAttribute(MODEL_MAP_KEY) == null) {
            this.request.getSession().setAttribute(MODEL_MAP_KEY, new HashMap());
        }
        HashMap modelMap = (HashMap)this.request.getSession().getAttribute(MODEL_MAP_KEY);
        String uuid = UUID.randomUUID().toString();
        RequestResultBean requestResult = (RequestResultBean)this.getModel().getAttribute("responseMessages");
        RedirectUrlBean redirectBean = ctrl.getRedirectUrlOnAppExceptionBean();
        if (redirectBean == null) {
            redirectBean = new RedirectUrlPageOnAppExceptionBean();
            modelMap.put(uuid, this.getModel());
        }
        redirectBean.putParam(CONTEXT_ID, new String[]{uuid.toString()});
        messagesMap.put(uuid.toString(), requestResult);
        String path = null;
        if (redirectBean instanceof RedirectUrlPageOnAppExceptionBean) {
            path = ((RedirectUrlPageOnAppExceptionBean)redirectBean).getUrl(this.util.getLoginState(), ctrl.getFunction(), ctrl.getDefaultSubFunctionOnAppException(), ctrl.getDefaultPageOnAppException());
        } else if (redirectBean instanceof RedirectUrlPathOnAppExceptionBean) {
            path = ((RedirectUrlPathOnAppExceptionBean)redirectBean).getUrl();
        } else {
            throw new RuntimeException("RedirectUrlBean\u304c\u60f3\u5b9a\u5916\u306e\u5024\u3067\u3059\u3002" + String.valueOf(redirectBean));
        }
        return new ModelAndView(path);
    }

    public static class ValidationErrorInfoBean {
        private String message;
        private String propertyPath;
        private String validatorClass;
        private String annotationDescriptionString;

        public ValidationErrorInfoBean(String message, String propertyPath, String validatorClass) {
            this.message = message;
            this.propertyPath = propertyPath;
            this.validatorClass = validatorClass;
            this.annotationDescriptionString = "";
        }

        public ValidationErrorInfoBean(ConstraintViolation<?> cv) {
            this.message = cv.getMessage();
            this.propertyPath = cv.getPropertyPath().toString();
            this.validatorClass = cv.getConstraintDescriptor().getAnnotation().annotationType().getName();
            this.annotationDescriptionString = cv.getConstraintDescriptor().getAnnotation().toString();
        }

        public String getMessage() {
            return this.message;
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        public String getValidatorClass() {
            return this.validatorClass;
        }

        public String getAnnotationDescriptionString() {
            return this.annotationDescriptionString;
        }
    }
}

