/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnSuccessBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathBean;
import jp.ecuacion.splib.web.controller.SplibGeneral1FormController;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibEditService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibEditController<E extends SplibEditForm>
extends SplibGeneral1FormController<E> {
    private PageTemplatePatternEnum pageTemplatePattern;
    protected RedirectUrlPathBean redirectPathOnSuccess;

    @Override
    public abstract SplibEditService getService();

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, @Nonnull String function) {
        this(pageTemplatePattern, function, new SplibGeneralController.ControllerContext());
    }

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, @Nonnull String function, SplibGeneralController.ControllerContext settings) {
        super(function, settings.subFunction("edit"));
        this.pageTemplatePattern = pageTemplatePattern;
    }

    @Override
    public String getDefaultSubFunctionOnSuccess() {
        return this.pageTemplatePattern == PageTemplatePatternEnum.SINGLE ? "edit" : "searchList";
    }

    @GetMapping(value={"page"}, params={"showInsertForm"})
    public String showInsertForm(Model model, E editForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, new SplibGeneralForm[]{editForm});
        ((SplibEditForm)editForm).setIsInsert(true);
        this.getService().page((SplibGeneralForm)editForm, loginUser);
        return this.getFunction() + "Edit";
    }

    @GetMapping(value={"page"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model, E editForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, new SplibGeneralForm[]{editForm});
        SplibEditForm form = this.getService().getUpdateForm((SplibEditForm)editForm);
        form.setIsInsert(false);
        form.setDataKind(((SplibGeneralForm)editForm).getDataKind());
        model.addAttribute(this.getFunction() + "EditForm", (Object)form);
        return this.getFunction() + "Edit";
    }

    @PostMapping(value={"action"}, params={"insertOrUpdate"})
    public String edit(@Validated E editForm, BindingResult result, Model model, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, (SplibGeneralForm)editForm, result, new SplibGeneralForm[0]);
        this.getService().edit((SplibEditForm)editForm, loginUser);
        RedirectUrlBean redirectBean = this.redirectPathOnSuccess == null ? new RedirectUrlPageOnSuccessBean() : this.redirectPathOnSuccess;
        redirectBean.putParam("dataKind", ((SplibGeneralForm)editForm).getDataKind());
        return this.getReturnStringOnSuccess(redirectBean);
    }

    @PostMapping(value={"action"}, params={"back"})
    public String back(@Validated E editForm, BindingResult result, Model model) {
        return this.getReturnStringOnSuccess(new RedirectUrlPageOnSuccessBean("searchList", "page").noSuccessMessage().putParam("dataKind", ((SplibGeneralForm)editForm).getDataKind()));
    }

    public static enum PageTemplatePatternEnum {
        SINGLE,
        PAIR_WITH_SEARCH_LIST;

    }
}

