package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneral1FormService;
import org.springframework.lang.NonNull;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class SplibGeneral1FormController<F extends SplibGeneralForm>
    extends SplibGeneralController {

  private StringUtil strUtil = new StringUtil();

  public abstract SplibGeneral1FormService getService();

  public SplibGeneral1FormController(@Nonnull String function) {
    super(function);
  }

  /** functionを指定したconstructor。functionだけは必須なのでconstructorの引数としている。 */
  protected SplibGeneral1FormController(@Nonnull String function,
      @NonNull ControllerContext settings) {
    super(function, settings);
  }

  @GetMapping("page")
  public String page(Model model, F newForm, @AuthenticationPrincipal UserDetails loginUser)
      throws Exception {
    @SuppressWarnings("unchecked")
    F form = (F) getForm(model, newForm);
    prepare(model, form);
    getService().page(form, loginUser);
    return getReturnStringToShowPage();
  }

  /** 場面によりget/post両方ありうるので両方記載しておく。 */
  @RequestMapping(value = "action", params = "submitOnChangeToRefresh=true",
      method = {RequestMethod.GET, RequestMethod.POST})
  public String submitOnChangeToRefresh(F form, Model model) throws Exception {
    prepare(model, form);
    model.addAttribute(getFunction() + strUtil.capitalize(getSubFunction()) + "Form", form);
    getService().prepareForm(form);
    return getFunction() + strUtil.capitalize(getSubFunction());
  }
}
