package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.service.SplibEditJpaService;
import jp.ecuacion.splib.web.service.SplibEditService;

public abstract class SplibEditJpaController<E extends SplibEditForm>
    extends SplibEditController<E> {

  public abstract SplibEditJpaService<?> getJpaService();

  public SplibEditService getService() {
    return getJpaService();
  }

  public SplibEditJpaController(PageTemplatePatternEnum pageTemplatePattern,
      @Nonnull String function) {
    super(pageTemplatePattern, function);
  }
  
  public SplibEditJpaController(PageTemplatePatternEnum pageTemplatePattern,
      @Nonnull String function, ControllerContext settings) {
    super(pageTemplatePattern, function, settings);
  }
  

  // public SplibEditJpaController(PageTemplatePatternEnum pageTemplatePattern,
  // @Nonnull String function, String rootRecordName) {
  // super(pageTemplatePattern, function, rootRecordName);
  // }
}
