package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import org.springframework.lang.NonNull;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class SplibGeneral2FormsController
    <F1 extends SplibGeneralForm, F2 extends SplibGeneralForm>
    extends SplibGeneralController {

  private StringUtil strUtil = new StringUtil();

  public SplibGeneral2FormsController(@Nonnull String function) {
    super(function);
  }

  /** functionを指定したconstructor。functionだけは必須なのでconstructorの引数としている。 */
  protected SplibGeneral2FormsController(@Nonnull String function,
      @NonNull ControllerContext settings) {
    super(function, settings);
  }

  /** 場面によりget/post両方ありうるので両方記載しておく。 */
  @RequestMapping(value = "action", params = "submitOnChangeToRefresh=true",
      method = {RequestMethod.GET, RequestMethod.POST})
  public String submitOnChangeToRefresh(F1 form1, F2 form2, Model model) throws Exception {
    prepare(model, form1, form2);
    model.addAttribute(getFunction() + strUtil.capitalize(getSubFunction()) + "Form", form2);
    getService().prepareForm(form2);
    return getFunction() + strUtil.capitalize(getSubFunction());
  }
}
