package jp.ecuacion.splib.web.advice;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import jp.ecuacion.splib.web.bean.RequestResultBean;
import jp.ecuacion.splib.web.bean.SplibModelAttributes;
import jp.ecuacion.splib.web.util.SplibUtil;
import jp.ecuacion.splib.web.util.internal.TransactionTokenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class SplibControllerAdvice {
  public static final String REQUEST_KEY_MODEL = "REQUEST_KEY_MODEL";

  @Autowired
  protected HttpServletRequest request;

  @Autowired
  private SplibModelAttributes modelAttr;

  @Autowired
  SplibUtil util;

  @ModelAttribute
  public void setObjectsToModel(Model model) {

    // modelをsessionに追加。adviceのExceptionHandlerでModelを使いたいのだが、
    // そこでmodelをDIで取得すると中身が空っぽのModelが取得されるため。
    request.setAttribute(REQUEST_KEY_MODEL, model);

    // messages, modelをredirect元から引き継いでいる場合はmodelに追加。
    String contextIdUuid = request.getParameter(SplibExceptionHandler.CONTEXT_ID);
    if (contextIdUuid != null && !contextIdUuid.equals("")) {
      // url parameterでrequestResultBeanKeyUuidが渡された場合のみの処理。
      // uuidは渡されたが、sessionが切れたなどでbeanMapが存在しない場合もあるため、beanMapが存在する際のみ実施

      // messageBean
      @SuppressWarnings("unchecked")
      Map<String, RequestResultBean> messageBeanMap = (Map<String, RequestResultBean>) request
          .getSession().getAttribute(SplibExceptionHandler.REQUEST_RESULT_MAP_KEY);

      if (messageBeanMap != null && messageBeanMap.get(contextIdUuid) != null) {
        model.addAttribute(RequestResultBean.key, messageBeanMap.get(contextIdUuid));

        // 一度使ったrequestResultBeanKeyUuidに対するものは、二度とは使用しないためにmapから削除。他に残っているものがあればそれ模索するためclearする
        messageBeanMap.clear();
      }

      // model
      @SuppressWarnings("unchecked")
      final Map<String, Model> modelMap = (HashMap<String, Model>) request.getSession()
          .getAttribute(SplibExceptionHandler.MODEL_MAP_KEY);

      if (modelMap != null && modelMap.get(contextIdUuid) != null) {
        // 別途渡しているrequestResultと重複してしまうので、modelからrequestResultを除いておく
        Map<String, Object> modelMapRedirectFrom = modelMap.get(contextIdUuid).asMap();
        modelMapRedirectFrom.remove(RequestResultBean.key);
        model.addAllAttributes(modelMapRedirectFrom);

        // 一度使ったrequestResultBeanKeyUuidに対するものは、二度とは使用しないためにmapから削除。他に残っているものがあればそれ模索するためclearする
        modelMap.clear();
      }
    }
    
    // requestResultBeanが引き継がれていない場合は、新規のRequestResultBeanを設定しておく
    if (!model.containsAttribute(RequestResultBean.key)) {
      model.addAttribute(RequestResultBean.key, new RequestResultBean());
    }

    // transactionToken
    model.addAttribute(TransactionTokenUtil.SESSION_KEY_TRANSACTION_TOKEN,
        new TransactionTokenUtil().issueNewToken(request));

    // url pathを追加。thymelaefでrequestの直接使用が不可になり、urlなどの使用はcontrollerでのmodelへの設定が推奨とのこと。
    model.addAttribute("loginState", util.getLoginState());

    // 個別appの中で、全画面共通で使用したいparameterを設定。
    modelAttr.addAllToModel(model);
  }
}
