/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.jpa.util;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.jpa.entity.EclibEntity;
import jp.ecuacion.splib.core.record.SplibRecord;
import jp.ecuacion.splib.web.item.HtmlItem;
import jp.ecuacion.splib.web.item.HtmlItemContainer;
import jp.ecuacion.splib.web.item.HtmlItemSelect;
import jp.ecuacion.splib.web.item.HtmlItemString;
import jp.ecuacion.splib.web.record.StringMatchingConditionBean;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class SpecFactory<T extends EclibEntity> {
    public Specification<T> equals(String propertyPath, Object value) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path<Object> path = this.getPath(root, propertyPath, value);
            return value == null || value instanceof String && ((String)value).equals("") ? null : cb.equal(path, value);
        };
    }

    public Specification<T> stringEqualsIgnoringCase(String propertyPath, String value) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path<String> criteriaField = this.getPath(root, propertyPath, value);
            return StringUtils.isEmpty((CharSequence)value) ? null : cb.equal(cb.upper(criteriaField), (Object)value.toUpperCase());
        };
    }

    public Specification<T> stringEquals(String propertyPath, String value, boolean ignoresCase) {
        return (Specification & Serializable)(root, query, cb) -> {
            Expression criteriaFieldTmp = this.getPath(root, propertyPath, value);
            Expression criteriaField = ignoresCase ? cb.upper(criteriaFieldTmp) : criteriaFieldTmp;
            String criteriaValue = ignoresCase ? value.toUpperCase() : value;
            return StringUtils.isEmpty((CharSequence)value) ? null : cb.equal(criteriaField, (Object)criteriaValue);
        };
    }

    public Specification<T> stringNotEquals(String propertyPath, String value) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path<String> criteriaField = this.getPath(root, propertyPath, value);
            String criteriaValue = value;
            return StringUtils.isEmpty((CharSequence)value) ? null : cb.notEqual(criteriaField, (Object)criteriaValue);
        };
    }

    public Specification<T> stringContains(String propertyPath, String value) {
        return this.stringContains(propertyPath, value, false);
    }

    private Specification<T> stringContains(String propertyPath, String value, boolean ignoresCase) {
        return this.stringSearchPattern(propertyPath, value, "%" + value + "%", ignoresCase);
    }

    public Specification<T> stringContainsIgnoringCase(String propertyPath, String value) {
        return this.stringContains(propertyPath, value, true);
    }

    public Specification<T> stringStartsWith(String propertyPath, String value) {
        return this.stringStartsWith(propertyPath, value, false);
    }

    private Specification<T> stringStartsWith(String propertyPath, String value, boolean ignoresCase) {
        return this.stringSearchPattern(propertyPath, value, value + "%", ignoresCase);
    }

    public Specification<T> stringStartsWithIgnoringCase(String propertyPath, String value) {
        return this.stringStartsWith(propertyPath, value, true);
    }

    public Specification<T> stringEndsWith(String propertyPath, String value) {
        return this.stringEndsWith(propertyPath, value, false);
    }

    private Specification<T> stringEndsWith(String propertyPath, String value, boolean ignoresCase) {
        return this.stringSearchPattern(propertyPath, value, "%" + value, ignoresCase);
    }

    public Specification<T> stringEndsWithIgnoringCase(String propertyPath, String value) {
        return this.stringEndsWith(propertyPath, value, true);
    }

    private Specification<T> stringSearchPattern(String propertyPath, String value, String criteriaValue, boolean ignoresCase) {
        return (Specification & Serializable)(root, query, cb) -> {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            Expression criteriaFieldTmp = this.getPath(root, propertyPath, value);
            Expression criteriaField = ignoresCase ? cb.upper(criteriaFieldTmp) : criteriaFieldTmp;
            String finalCriteriaValue = ignoresCase ? criteriaValue.toUpperCase() : criteriaValue;
            return cb.like(criteriaField, finalCriteriaValue);
        };
    }

    public Specification<T> localDateEqualToOrLessThan(String field, LocalDate date) {
        return this.localDateEqualToOrLessThan(null, field, date);
    }

    public Specification<T> localDateEqualToOrLessThan(String entity, String field, LocalDate date) {
        return date == null ? null : (Specification & Serializable)(root, query, cb) -> {
            Path criteriaField = entity == null ? root.get(field) : root.get(entity).get(field);
            return cb.or((Expression)cb.equal(criteriaField.as(LocalDate.class), (Object)date), (Expression)cb.lessThan(criteriaField.as(LocalDate.class), (Comparable)date));
        };
    }

    public Specification<T> localDateEqualToOrGreaterThan(String field, LocalDate date) {
        return date == null ? null : (Specification & Serializable)(root, query, cb) -> cb.or((Expression)cb.equal(root.get(field).as(LocalDate.class), (Object)date), (Expression)cb.greaterThan(root.get(field).as(LocalDate.class), (Comparable)date));
    }

    public Specification<T> localDateEqualToOrGreaterThan(String entity, String field, LocalDate date) {
        return date == null ? null : (Specification & Serializable)(root, query, cb) -> {
            Path criteriaField = entity == null ? root.get(field) : root.get(entity).get(field);
            return cb.or((Expression)cb.equal(criteriaField.as(LocalDate.class), (Object)date), (Expression)cb.greaterThan(criteriaField.as(LocalDate.class), (Comparable)date));
        };
    }

    private Specification<T> selectSearchPattern(String propertyPath, String value, String criteriaValue, boolean ignoresCase) {
        return (Specification & Serializable)(root, query, cb) -> {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            Expression criteriaFieldTmp = this.getPath(root, propertyPath, value);
            Expression criteriaField = ignoresCase ? cb.upper(criteriaFieldTmp) : criteriaFieldTmp;
            String finalCriteriaValue = ignoresCase ? criteriaValue.toUpperCase() : criteriaValue;
            return cb.like(criteriaField, finalCriteriaValue);
        };
    }

    private <X> Path<X> getPath(Root<T> root, String propertyPath, X value) {
        String[] fields = propertyPath.split("\\.");
        Path path = null;
        for (int i = 0; i < fields.length; ++i) {
            path = path == null ? root.get(fields[i]) : path.get(fields[i]);
        }
        return path;
    }

    public List<Specification<T>> addExplicitSearchConditions(SplibRecord rec) {
        ArrayList<Specification<T>> list = new ArrayList<Specification<T>>();
        for (HtmlItem item : ((HtmlItemContainer)rec).getHtmlItems()) {
            String propertyPath = item.getItemPropertyPath();
            Object value = null;
            try {
                value = rec.getValue(propertyPath);
            }
            catch (EclibRuntimeException ex) {
                if (ex.getCause() instanceof NoSuchMethodException) continue;
                throw ex;
            }
            if (item instanceof HtmlItemString) {
                HtmlItemString stringItem = (HtmlItemString)item;
                if (stringItem.getStringSearchPatternEnum() == StringMatchingConditionBean.StringMatchingPatternEnum.EXACT) {
                    list.add(this.stringEquals(propertyPath, (String)value, stringItem.isIgnoresCase()));
                    continue;
                }
                if (stringItem.getStringSearchPatternEnum() == StringMatchingConditionBean.StringMatchingPatternEnum.PARTIAL) {
                    list.add(this.stringContains(propertyPath, (String)value, stringItem.isIgnoresCase()));
                    continue;
                }
                if (stringItem.getStringSearchPatternEnum() == StringMatchingConditionBean.StringMatchingPatternEnum.PREFIX) {
                    list.add(this.stringStartsWith(propertyPath, (String)value, stringItem.isIgnoresCase()));
                    continue;
                }
                if (stringItem.getStringSearchPatternEnum() != StringMatchingConditionBean.StringMatchingPatternEnum.POSTFIX) continue;
                list.add(this.stringEndsWith(propertyPath, (String)value, stringItem.isIgnoresCase()));
                continue;
            }
            if (!(item instanceof HtmlItemSelect)) continue;
            list.add(this.equals(propertyPath, value));
        }
        return list;
    }
}

