/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.jpa.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.lang.reflect.Method;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.jpa.entity.EclibEntity;
import jp.ecuacion.splib.core.bl.SplibCoreBl;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.jpa.service.SplibJpaServiceInterface;
import jp.ecuacion.splib.web.service.SplibEditService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.repository.ListCrudRepository;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
public abstract class SplibEditJpaService<F extends SplibEditForm, E extends EclibEntity>
extends SplibEditService<F>
implements SplibJpaServiceInterface<E> {
    @PersistenceContext
    protected EntityManager em;

    protected <T extends EclibEntity> T insertOrUpdate(SplibRepository<T, ?> repo, T e) {
        return (T)((EclibEntity)repo.save(e));
    }

    protected <T, I> void duplicateInGroupCheck(ListCrudRepository<T, I> repo, String checkTargetItemPropertyPath, String checkTargetFieldItemNameKey, String checkTargetFieldValue, String idFieldName, I idValueOfSelf) throws BizLogicAppException {
        this.duplicateInListCheck(repo.findAll(), checkTargetItemPropertyPath, checkTargetFieldItemNameKey, checkTargetFieldValue, idFieldName, idValueOfSelf);
    }

    protected <T, I> void duplicateInListCheck(List<T> entityList, String checkTargetItemPropertyPath, String checkTargetFieldItemNameKey, String checkTargetFieldValue, String idFieldName, I idValueOfSelf) throws BizLogicAppException {
        boolean bl = entityList.stream().filter(e -> !this.getValue(e, idFieldName).equals(idValueOfSelf)).map(e -> this.getValue(e, checkTargetItemPropertyPath)).toList().contains(checkTargetFieldValue);
        SplibCoreBl.throwExceptionWhenDuplicated((boolean)bl, (String[])new String[]{checkTargetItemPropertyPath}, (String[])new String[]{checkTargetFieldItemNameKey});
    }

    private <T> Object getValue(T e, String fieldName) {
        try {
            Method getNameMethod = e.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
            return getNameMethod.invoke(e, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

