/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.jpa.util;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.ecuacion.lib.jpa.entity.EclibEntity;
import jp.ecuacion.splib.core.record.SplibRecord;
import jp.ecuacion.splib.web.item.SplibWebSearchItemContainer;
import jp.ecuacion.splib.web.record.StringMatchingConditionBean;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class SpecFactory<T extends EclibEntity> {
    public Specification<T> equals(String field, Object value) {
        return (Specification & Serializable)(root, query, cb) -> {
            String[] entities = field.split("\\.");
            Root path = root;
            for (int i = 0; i < entities.length; ++i) {
                path = path.get(entities[i]);
            }
            return value == null || value instanceof String && ((String)value).equals("") ? null : cb.equal((Expression)path, value);
        };
    }

    public Specification<T> stringEqualsIgnoringCase(String field, String value) {
        return this.stringEqualsIgnoringCase(null, field, value);
    }

    public Specification<T> stringEqualsIgnoringCase(String entity, String field, String value) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path criteriaField = entity == null ? root.get(field) : root.get(entity).get(field);
            return StringUtils.isEmpty((CharSequence)value) ? null : cb.equal(cb.upper((Expression)criteriaField), (Object)value.toUpperCase());
        };
    }

    public Specification<T> stringEquals(String field, String value, boolean ignoresCase) {
        return this.stringEquals(null, field, value, ignoresCase);
    }

    public Specification<T> stringEquals(String entity, String field, String value, boolean ignoresCase) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path criteriaFieldTmp = entity == null ? root.get(field) : root.get(entity).get(field);
            Path criteriaField = ignoresCase ? cb.upper((Expression)criteriaFieldTmp) : criteriaFieldTmp;
            String criteriaValue = ignoresCase ? value.toUpperCase() : value;
            return StringUtils.isEmpty((CharSequence)value) ? null : cb.equal((Expression)criteriaField, (Object)criteriaValue);
        };
    }

    public Specification<T> stringNotEquals(String field, String value) {
        return this.stringNotEquals(null, field, value);
    }

    public Specification<T> stringNotEquals(String entity, String field, String value) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path criteriaField = entity == null ? root.get(field) : root.get(entity).get(field);
            String criteriaValue = value;
            return StringUtils.isEmpty((CharSequence)value) ? null : cb.notEqual((Expression)criteriaField, (Object)criteriaValue);
        };
    }

    public Specification<T> stringContains(String field, String value) {
        return this.stringContains(null, field, value, false);
    }

    public Specification<T> stringContains(String entity, String field, String value) {
        return this.stringContains(entity, field, value, false);
    }

    private Specification<T> stringContains(String entity, String field, String value, boolean ignoresCase) {
        return this.stringSearchPattern(entity, field, value, "%" + value + "%", ignoresCase);
    }

    public Specification<T> stringContainsIgnoringCase(String field, String value) {
        return this.stringContains(null, field, value, true);
    }

    public Specification<T> stringContainsIgnoringCase(String entity, String field, String value) {
        return this.stringContains(entity, field, value, true);
    }

    public Specification<T> stringStartsWith(String field, String value) {
        return this.stringStartsWith(null, field, value, false);
    }

    public Specification<T> stringStartsWith(String entity, String field, String value) {
        return this.stringStartsWith(entity, field, value, false);
    }

    private Specification<T> stringStartsWith(String entity, String field, String value, boolean ignoresCase) {
        return this.stringSearchPattern(entity, field, value, value + "%", ignoresCase);
    }

    public Specification<T> stringStartsWithIgnoringCase(String field, String value) {
        return this.stringStartsWith(null, field, value, true);
    }

    public Specification<T> stringStartsWithIgnoringCase(String entity, String field, String value) {
        return this.stringStartsWith(entity, field, value, true);
    }

    public Specification<T> stringEndsWith(String field, String value) {
        return this.stringEndsWith(null, field, value, false);
    }

    public Specification<T> stringEndsWith(String entity, String field, String value) {
        return this.stringEndsWith(entity, field, value, false);
    }

    private Specification<T> stringEndsWith(String entity, String field, String value, boolean ignoresCase) {
        return this.stringSearchPattern(entity, field, value, "%" + value, ignoresCase);
    }

    public Specification<T> stringEndsWithIgnoringCase(String field, String value) {
        return this.stringEndsWith(null, field, value, true);
    }

    public Specification<T> stringEndsWithIgnoringCase(String entity, String field, String value) {
        return this.stringEndsWith(entity, field, value, true);
    }

    private Specification<T> stringSearchPattern(String entity, String field, String value, String criteriaValue, boolean ignoresCase) {
        return (Specification & Serializable)(root, query, cb) -> {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            Path criteriaFieldTmp = entity == null ? root.get(field) : root.get(entity).get(field);
            Path criteriaField = ignoresCase ? cb.upper((Expression)criteriaFieldTmp) : criteriaFieldTmp;
            String finalCriteriaValue = ignoresCase ? criteriaValue.toUpperCase() : criteriaValue;
            return cb.like((Expression)criteriaField, finalCriteriaValue);
        };
    }

    public Specification<T> localDateEqualToOrLessThan(String field, LocalDate date) {
        return this.localDateEqualToOrLessThan(null, field, date);
    }

    public Specification<T> localDateEqualToOrLessThan(String entity, String field, LocalDate date) {
        return date == null ? null : (Specification & Serializable)(root, query, cb) -> {
            Path criteriaField = entity == null ? root.get(field) : root.get(entity).get(field);
            return cb.or((Expression)cb.equal(criteriaField.as(LocalDate.class), (Object)date), (Expression)cb.lessThan(criteriaField.as(LocalDate.class), (Comparable)date));
        };
    }

    public Specification<T> localDateEqualToOrGreaterThan(String field, LocalDate date) {
        return date == null ? null : (Specification & Serializable)(root, query, cb) -> cb.or((Expression)cb.equal(root.get(field).as(LocalDate.class), (Object)date), (Expression)cb.greaterThan(root.get(field).as(LocalDate.class), (Comparable)date));
    }

    public Specification<T> localDateEqualToOrGreaterThan(String entity, String field, LocalDate date) {
        return date == null ? null : (Specification & Serializable)(root, query, cb) -> {
            Path criteriaField = entity == null ? root.get(field) : root.get(entity).get(field);
            return cb.or((Expression)cb.equal(criteriaField.as(LocalDate.class), (Object)date), (Expression)cb.greaterThan(criteriaField.as(LocalDate.class), (Comparable)date));
        };
    }

    public List<Specification<T>> addStringSearchConditions(SplibRecord rec) {
        ArrayList<Specification<T>> list = new ArrayList<Specification<T>>();
        for (Map.Entry entry : ((SplibWebSearchItemContainer)rec).getSearchPatterns().entrySet()) {
            String field;
            String key = (String)entry.getKey();
            String entity = key.contains(".") ? key.substring(0, key.indexOf(".")) : null;
            String string = field = key.contains(".") ? key.substring(key.indexOf(".") + 1) : key;
            if (((StringMatchingConditionBean)entry.getValue()).getStringSearchPatternEnum() == StringMatchingConditionBean.StringMatchingPatternEnum.EXACT) {
                list.add(this.stringEquals(entity, field, (String)rec.getValue((String)entry.getKey()), ((StringMatchingConditionBean)entry.getValue()).isIgnoresCase()));
                continue;
            }
            if (((StringMatchingConditionBean)entry.getValue()).getStringSearchPatternEnum() == StringMatchingConditionBean.StringMatchingPatternEnum.PARTIAL) {
                list.add(this.stringContains(entity, field, (String)rec.getValue((String)entry.getKey()), ((StringMatchingConditionBean)entry.getValue()).isIgnoresCase()));
                continue;
            }
            if (((StringMatchingConditionBean)entry.getValue()).getStringSearchPatternEnum() == StringMatchingConditionBean.StringMatchingPatternEnum.PREFIX) {
                list.add(this.stringStartsWith(entity, field, (String)rec.getValue((String)entry.getKey()), ((StringMatchingConditionBean)entry.getValue()).isIgnoresCase()));
                continue;
            }
            if (((StringMatchingConditionBean)entry.getValue()).getStringSearchPatternEnum() != StringMatchingConditionBean.StringMatchingPatternEnum.POSTFIX) continue;
            list.add(this.stringEndsWith(entity, field, (String)rec.getValue((String)entry.getKey()), ((StringMatchingConditionBean)entry.getValue()).isIgnoresCase()));
        }
        return list;
    }
}

