/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.jpa.service;

import jakarta.persistence.EntityManager;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import jp.ecuacion.lib.jpa.entity.AbstractEntity;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.jpa.service.SplibJpaServiceInterface;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
public abstract class SplibSearchListJpaService<FST extends SplibSearchForm, FLT extends SplibListForm<?>, E extends AbstractEntity>
extends SplibSearchListService<FST, FLT>
implements SplibJpaServiceInterface<E> {
    @Autowired
    private HttpServletRequest request;
    protected EntityManager em;

    public DatetimeFormatParameters getParams() {
        return new SplibUtil().getParams(this.request);
    }

    protected LocalDate localDate(String date) {
        return date == null || date.equals("") ? null : LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    protected abstract Specification<E> getSpecs(FST var1);

    protected Page<E> getListFormCommon(FST searchForm, JpaSpecificationExecutor<E> repository) {
        Specification<E> specs = this.getSpecs(searchForm);
        searchForm.setNumberOfRecordsAndAdjustCurrentPageNumger(Long.valueOf(repository.count(specs)));
        return repository.findAll(specs, (Pageable)searchForm.getPageRequest());
    }
}

