/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.rest.advice;

import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.splib.rest.exception.HttpStatusException;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.ErrorResponse;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class SplibRestExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={HttpStatusException.class})
    public ResponseEntity<?> handleHttpStatusException(HttpStatusException exception, WebRequest request) {
        return new ResponseEntity((MultiValueMap)new LinkedMultiValueMap(), (HttpStatusCode)exception.getHttpStatus());
    }

    @ExceptionHandler(value={Throwable.class})
    public ErrorResponse handleThrowable(Throwable exception) {
        LogUtil.logSystemError((DetailLogger)new DetailLogger((Object)this), (Throwable)exception);
        return ErrorResponse.create((Throwable)exception, (HttpStatusCode)HttpStatusCode.valueOf((int)501), (String)"Internal Server Error...");
    }
}

