/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.jpa.advice;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Optional;
import jp.ecuacion.lib.jpa.entity.EclibEntity;
import jp.ecuacion.splib.jpa.bean.SplibControllerAdviceInfoBean;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import jp.ecuacion.splib.jpa.util.SplibJpaFilterUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SplibSoftDeleteAdvice {
    @Autowired
    private SplibJpaFilterUtil filterUtil;
    @PersistenceContext
    private EntityManager em;

    @Before(value="execution(* *..*.base.repository.*.save(..))")
    public void onBeforeSave(JoinPoint joinPoint) {
        this.beforeAdvice((EclibEntity)joinPoint.getArgs()[0], (SplibRepository)joinPoint.getThis());
    }

    private void beforeAdvice(EclibEntity entity, SplibRepository<EclibEntity, ?> repo) {
        Object groupId = SplibControllerAdviceInfoBean.getGroupId();
        this.filterUtil.disableAllFilters();
        this.physicalDeleteSoftDeletedRecords(entity, repo);
        this.filterUtil.enableAllFilters(groupId);
    }

    private <T extends EclibEntity> void physicalDeleteSoftDeletedRecords(T entity, SplibRepository<T, ?> repo) {
        boolean isUpdate = this.em.contains(entity);
        if (entity.hasSoftDeleteField()) {
            Optional<T> result;
            if (isUpdate) {
                this.em.flush();
                this.em.detach(entity);
            }
            if ((result = repo.findByIdAndSoftDeleteFieldTrueFromAllGroups(entity)).isPresent()) {
                repo.delete((EclibEntity)result.get());
                repo.flush();
            }
            if (entity.hasNaturalKey() && (result = repo.findByNaturalKeyAndSoftDeleteFieldTrueFromAllGroups(entity)).isPresent()) {
                repo.delete((EclibEntity)result.get());
                repo.flush();
            }
            if (isUpdate) {
                entity = (EclibEntity)this.em.merge(entity);
            }
        }
    }
}

