/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.jpa.bl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.item.EclibItemContainer;
import jp.ecuacion.lib.jpa.entity.EclibEntity;
import jp.ecuacion.splib.core.bl.SplibCoreBl;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.orm.ObjectOptimisticLockingFailureException;

public abstract class SplibJpaBl<E extends EclibEntity, I, V>
extends SplibCoreBl {
    public abstract SplibRepository<E, I> getRepositoryForOptimisticLocking();

    public abstract V getVersionForOptimisticLocking(E var1);

    public E findAndOptimisticLockingCheck(I id, V version) throws AppException {
        Optional optional = this.getRepositoryForOptimisticLocking().findById(id);
        if (optional.isEmpty()) {
            String msg = "jp.ecuacion.splib.web.common.message.sameRecordAlreadyDeleted";
            throw new BizLogicAppException(msg, new String[0]);
        }
        EclibEntity e = (EclibEntity)optional.get();
        if (!this.isVersionsTheSame(version, this.getVersionForOptimisticLocking(e))) {
            throw new ObjectOptimisticLockingFailureException("some class", id);
        }
        return (E)e;
    }

    private boolean isVersionsTheSame(V vers1, V vers2) {
        if (vers1 == null || vers2 == null) {
            throw new RuntimeException("Optimistic Locking check cannot be done because version array is null.");
        }
        return vers1.equals(vers2);
    }

    protected <T> void internalDuplicateCheck(List<T> entityList, EclibItemContainer rec, String itemNameKeyClass, String idItemPropertyPath, String ... checkTargetItemPropertyPaths) throws BizLogicAppException {
        List<Object> listWithoutMyself = entityList.stream().filter(e -> !this.getValue(e, idItemPropertyPath).equals(this.getValue(rec, idItemPropertyPath))).toList();
        for (String path2 : checkTargetItemPropertyPaths) {
            listWithoutMyself = listWithoutMyself.stream().filter(e -> this.getValue(e, path2).equals(this.getValue(rec, path2))).toList();
        }
        List<String> itemNameKeys = Arrays.asList(checkTargetItemPropertyPaths).stream().map(path -> rec.getItem(path).getItemNameKey(itemNameKeyClass)).toList();
        SplibCoreBl.throwExceptionWhenDuplicated((listWithoutMyself.size() > 0 ? 1 : 0) != 0, (String[])checkTargetItemPropertyPaths, (String[])itemNameKeys.toArray(new String[itemNameKeys.size()]));
    }

    protected <T> Object getValue(T obj, String fieldName) {
        try {
            Method getNameMethod = null;
            try {
                getNameMethod = obj.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName) + "OfEntityDataType", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                getNameMethod = obj.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
            }
            return getNameMethod.invoke(obj, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

