/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.jpa.bl;

import java.util.Optional;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.jpa.entity.EclibEntity;
import jp.ecuacion.splib.core.bl.SplibCoreBl;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import org.springframework.orm.ObjectOptimisticLockingFailureException;

public abstract class SplibJpaBl<E extends EclibEntity, I, V>
extends SplibCoreBl {
    public abstract SplibRepository<E, I> getRepositoryForOptimisticLocking();

    public abstract V getVersionForOptimisticLocking(E var1);

    public E findAndOptimisticLockingCheck(I id, V version) throws AppException {
        Optional optional = this.getRepositoryForOptimisticLocking().findById(id);
        if (optional.isEmpty()) {
            String msg = "jp.ecuacion.splib.web.common.message.sameRecordAlreadyDeleted";
            throw new BizLogicAppException(msg, new String[0]);
        }
        EclibEntity e = (EclibEntity)optional.get();
        if (!this.isVersionsTheSame(version, this.getVersionForOptimisticLocking(e))) {
            throw new ObjectOptimisticLockingFailureException("some class", id);
        }
        return (E)e;
    }

    private boolean isVersionsTheSame(V vers1, V vers2) {
        if (vers1 == null || vers2 == null) {
            throw new RuntimeException("Optimistic Locking check cannot be done because version array is null.");
        }
        return vers1.equals(vers2);
    }
}

