/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.jpa.advice;

import java.util.Optional;
import jp.ecuacion.lib.jpa.entity.AbstractEntity;
import jp.ecuacion.splib.jpa.bean.SplibControllerAdviceInfoBean;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import jp.ecuacion.splib.jpa.util.SplibJpaFilterUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SplibSoftDeleteAdvice {
    @Autowired
    private SplibJpaFilterUtil filterUtil;

    @Before(value="execution(* *..*.base.repository.*.save(..))")
    public void onBeforeSave(JoinPoint joinPoint) {
        this.beforeAdvice((AbstractEntity)joinPoint.getArgs()[0], (SplibRepository)joinPoint.getThis());
    }

    private void beforeAdvice(AbstractEntity entity, SplibRepository<AbstractEntity, ?> repo) {
        Object groupId = SplibControllerAdviceInfoBean.getGroupId();
        this.filterUtil.disableAllFilters();
        this.physicalDeleteSoftDeletedRecords(entity, repo);
        this.filterUtil.enableAllFilters(groupId);
    }

    private void physicalDeleteSoftDeletedRecords(AbstractEntity entity, SplibRepository<AbstractEntity, ?> repo) {
        if (entity.hasSoftDeleteField()) {
            Optional<AbstractEntity> result = repo.findByIdAndSoftDeleteFieldTrueFromAllGroups(entity);
            if (result.isPresent()) {
                repo.delete(result.get());
                repo.flush();
            }
            if (entity.hasNaturalKey() && (result = repo.findByNaturalKeyAndSoftDeleteFieldTrueFromAllGroups(entity)).isPresent()) {
                repo.delete(result.get());
                repo.flush();
            }
        }
    }
}

