/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.jpa.advice;

import java.util.Optional;
import jp.ecuacion.lib.jpa.entity.AbstractEntity;
import jp.ecuacion.splib.jpa.bean.SplibSoftDeleteAdviceInfoBean;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import jp.ecuacion.splib.jpa.util.SplibJpaFilterUtil;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SplibSoftDeleteAdvice {
    @Autowired
    private SplibJpaFilterUtil filterUtil;

    public void beforeAdvice(AbstractEntity entity, SplibRepository<AbstractEntity, ?> repo) {
        Object groupId = SplibSoftDeleteAdviceInfoBean.getGroupId();
        this.disableAllFilters(groupId);
        this.physicalDeleteSoftDeletedRecords(entity, repo);
        this.enableAllFilters(groupId);
    }

    private void physicalDeleteSoftDeletedRecords(AbstractEntity entity, SplibRepository<AbstractEntity, ?> repo) {
        if (entity.hasSoftDeleteField()) {
            Optional<AbstractEntity> result = repo.findByIdAndSoftDeleteFieldTrueFromAllGroups(entity);
            if (result.isPresent()) {
                repo.delete(result.get());
                repo.flush();
            }
            if (entity.hasNaturalKey() && (result = repo.findByNaturalKeyAndSoftDeleteFieldTrueFromAllGroups(entity)).isPresent()) {
                repo.delete(result.get());
                repo.flush();
            }
        }
    }

    protected void enableAllFilters(Object groupId) {
        this.filterUtil.enableSoftDeleteFilter();
        if (groupId != null) {
            this.filterUtil.enableGroupFilter(groupId);
        }
    }

    protected void disableAllFilters(Object groupId) {
        this.filterUtil.disableSoftDeleteFilter();
        if (groupId != null) {
            this.filterUtil.disableGroupFilter();
        }
    }
}

