package jp.ecuacion.splib.jpa.util;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.hibernate.Filter;
import org.hibernate.Session;

public abstract class SplibJpaFilterUtil {

  @PersistenceContext
  EntityManager em;

  private boolean usesSoftDeleteFeature;
  private boolean usesGroupFeature;
  private String groupColumnName;
  private boolean hasCustomGroupColumn;
  private String customGroupName;
  private String customGroupColumnName;

  public SplibJpaFilterUtil(boolean usesSoftDeleteFeature, boolean usesGroupFeature,
      String groupColumnName, boolean hasCustomGroupColumn, String customGroupName,
      String customGroupColumnName) {
    this.usesSoftDeleteFeature = usesSoftDeleteFeature;
    this.usesGroupFeature = usesGroupFeature;
    this.groupColumnName = groupColumnName;
    this.hasCustomGroupColumn = hasCustomGroupColumn;
    this.customGroupName = customGroupName;
    this.customGroupColumnName = customGroupColumnName;
  }

  public void enableGroupFilter(Object groupId) {
    if (usesGroupFeature) {
      Session session = em.unwrap(Session.class);
      Filter filter = session.enableFilter("groupFilter");
      filter.setParameter(groupColumnName, groupId);

      if (hasCustomGroupColumn) {
        Filter filterAccGroup = session.enableFilter(customGroupName);
        filterAccGroup.setParameter(customGroupColumnName, groupId);
      }
    }
  }

  public void disableGroupFilter() {
    if (usesGroupFeature) {
      Session session = em.unwrap(Session.class);
      session.disableFilter("groupFilter");

      if (hasCustomGroupColumn) {
        session.disableFilter(customGroupName);
      }
    }
  }

  public void enableSoftDeleteFilter() {
    if (usesSoftDeleteFeature) {
      Session session = em.unwrap(Session.class);
      session.enableFilter("softDeleteFilter");
    }
  }

  public void disableSoftDeleteFilter() {
    if (usesSoftDeleteFeature) {
      Session session = em.unwrap(Session.class);
      session.disableFilter("softDeleteFilter");
    }
  }
}
