package jp.ecuacion.splib.jpa.advice;

import java.util.Optional;
import jp.ecuacion.lib.core.entity.AbstractEntity;
import jp.ecuacion.splib.jpa.repository.SplibRepository;

public abstract class SplibSoftDeleteAdvice {

  public void beforeAdvice(AbstractEntity entity, SplibRepository<AbstractEntity, ?> repo) {

    if (entity.hasSoftDeleteField()) {
      // 同一IDで削除済みのレコード存在チェック。あれば削除
      Optional<AbstractEntity> result = repo.findByIdAndSoftDeleteFieldTrueFromAllGroups(entity);
      if (result.isPresent()) {
        // native sqlでdeleteすると以下のエラーとなった。
        // どうやらnative sqlでdeleteしたものが探せなくなり、でも同一IDのentityが2つありエラーとなるようだ。
        // "A different object with the same identifier value was already associated with the
        // session"
        // repo.deleteByIdAndSoftDeleteFieldTrueFromAllGroups(entity);

        // jpaのdeleteを使うと動いた。deleteは削除フラグが立ってる状態でも見えるのね。
        repo.delete(result.get());
      }

      // 上記同様、同一Unique Keyで削除済みのレコード存在チェック。あれば削除
      if (entity.hasNaturalKey()) {
        result = repo.findByNaturalKeyAndSoftDeleteFieldTrueFromAllGroups(entity);
        if (result.isPresent()) {
          repo.deleteByIdAndSoftDeleteFieldTrueFromAllGroups(result.get());
        }
      }
    }
  }
}
