package jp.ecuacion.splib.jpa.repository;

import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.query.Param;

@NoRepositoryBean
public interface SplibRepository<T, I> extends JpaRepository<T, I> {
  
  Optional<T> findByIdAndSoftDeleteFieldTrueFromAllGroups(@Param("entity") T entity);

  Optional<T> findByNaturalKeyAndSoftDeleteFieldTrueFromAllGroups(@Param("entity") T entity);

  @Modifying
  void deleteByIdAndSoftDeleteFieldTrueFromAllGroups(@Param("entity") T entity);

}
