package jp.ecuacion.splib.jpa.advice;

import java.util.Optional;
import jp.ecuacion.lib.jpa.entity.AbstractEntity;
import jp.ecuacion.splib.jpa.repository.SplibJpaRepository;

public abstract class SplibJpaSoftDeleteAdvice {

  public void beforeAdvice(AbstractEntity entity, SplibJpaRepository<AbstractEntity, ?> repo) {
     
    if (entity.hasSoftDeleteField()) {
      // 同一IDで削除済みのレコード存在チェック。あれば削除
      Optional<AbstractEntity> result = repo.findByIdAndSoftDeleteFieldTrueFromAllGroups(entity);
      if (result.isPresent()) {
        repo.deleteByIdAndSoftDeleteFieldTrueFromAllGroups(entity);
      }
      
      // 上記同様、同一Unique Keyで削除済みのレコード存在チェック。あれば削除
      if (entity.hasNaturalKey()) {
        result = repo.findByNaturalKeyAndSoftDeleteFieldTrueFromAllGroups(entity);
        if (result.isPresent()) {
          repo.deleteByIdAndSoftDeleteFieldTrueFromAllGroups(entity);
        }
      }
    }
  }
}
