package jp.ecuacion.splib.jpa.config;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapper;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapperImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan("jp.ecuacion.splib.core.config"
    + ",jp.ecuacion.splib.jpa.entitymanager"
    )
public class SplibJpaConfig {
  
  @PersistenceContext
  private EntityManager entityManager;
  
  @Bean
  public EntityManagerWrapper entityManagerWrapper() {
    return new EntityManagerWrapperImpl(entityManager);
  }
}
