package jp.ecuacion.splib.jpa.form.record;

import java.lang.reflect.Method;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.lib.jpa.dto.record.AbstractRecord;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;

public abstract class SplibJpaRecord extends AbstractRecord {

  private StringUtil strUtil = new StringUtil();
  
  protected DatetimeFormatParameters dateTimeFormatParams;

  public SplibJpaRecord() {
    // defaultを使用
    dateTimeFormatParams = new DatetimeFormatParameters();
  }

  public SplibJpaRecord(DatetimeFormatParameters params) {
    this.dateTimeFormatParams = params;
  }

  public Object getValue(String itemName) {
    Object rtn = null;

    try {
      if (itemName.contains(".")) {
        String recordName = itemName.substring(0, itemName.indexOf("."));
        String fieldName = itemName.substring(itemName.indexOf(".") + 1);

        Method m = this.getClass().getMethod("get" + strUtil.capitalize(recordName));
        rtn = ((SplibJpaRecord) m.invoke(this)).getValue(fieldName);
        
      } else {
        Method m = this.getClass().getMethod("get" + strUtil.capitalize(itemName));
        // Stringの場合とSplibJpaRecordの場合があるが、Objectで返すだけなので条件分岐は不要。
        rtn = m.invoke(this);
      }
      
    } catch (Exception e) {
       throw new RuntimeException(e);
    }

    return rtn;
  }
  
  public DatetimeFormatParameters getDateTimeFormatParams() {
    return dateTimeFormatParams;
  }

  public void setDateTimeFormatParams(DatetimeFormatParameters dateTimeFormatParams) {
    this.dateTimeFormatParams = dateTimeFormatParams;
  }
}
