package jp.ecuacion.splib.jpa.entitymanager;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContext;
import jp.ecuacion.lib.jpa.dbaccess.DbAccessManager;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/**
 * DIされるEntityManagerは、threadごとに異なる値が格納される。
 * EntityManagerがDIされるためには本クラスもcontainer管理にする必要があるが、本クラスがsingletonでは意味がない。
 * EntityManagerと同じく@PersistenceContextをつければきれいになるのかもしれないが、よくわからないのでprototype scopeとしておく
 * 
 * @author yosuke.tanaka
 *
 */
@Component
@Scope("prototype")
public class DbAccessManagerWithSpringJpa extends DbAccessManager {

  @PersistenceContext
  private EntityManager entityManager;
  @Autowired
  private EntityManagerFactory emf;
  
  private JpaTransactionManager tm;
  private TransactionStatus status;
    
  @Override
  protected EntityManager getOriginalEntityManager() {
    return entityManager;
  }
  
  public JpaTransactionManager getTransactionManager() {
    return tm;
  }

  @Override
  protected EntityManagerWrapper innerInitTransaction(EntityManagerWrapper entityManager) {
    //transactionManagerを生成
    tm = new JpaTransactionManager(emf);
    DefaultTransactionDefinition td = new DefaultTransactionDefinition();
    td.setName("transaction");
    td.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRED);
    status = tm.getTransaction(td);

    return entityManager;
  }
  
  @Override
  public void commitTransaction(EntityManagerWrapper entityManager) {
    tm.commit(status);
  }
  
  @Override
  public void rollbackTransaction(EntityManagerWrapper entityManager) {
    tm.rollback(status);
  }
}
